// Setup - a Windows CE Install Application tool (part of the EZSetup package)
// Copyright (C) 1999 Scott Ludwig
// scottlu@eskimo.com
// http://www.eskimo.com/~scottlu
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// or visit http://www.gnu.org/copyleft/gpl.html.
//

// Change history:
//
// 06/23/99		Scott Ludwig (scottlu@eskimo.com)
//				Created and released Setup v1.0
//

#include <windows.h>
#include "resource.h"


// GANDALF: function for reading messages from text files.
char *TextFromFile(char *szFullFn);


HINSTANCE ghInst;

char *GetTextFileResource(int idr)
{
	HRSRC hr = FindResource(NULL, MAKEINTRESOURCE(idr), MAKEINTRESOURCE(kidtTEXTFILES));
	HGLOBAL h = LoadResource(NULL, hr);
	return (char *)LockResource(h);
}

BOOL CALLBACK WelcomeDlgProc(HWND hwnd, UINT wm, WPARAM wp, LPARAM lp)
{
	char *msgbuf = NULL; // GANDALF: buffer for the Welcome dialog message.

	switch (wm) {
	case WM_INITDIALOG:
		// Grab the readme.txt resource and stick it in the edit control

		// SetDlgItemText(hwnd, kidcEdit, GetTextFileResource(kidrReadme));


		// GANDALF: get message from readme file.
		msgbuf = TextFromFile(".//readmeimame.txt");
		if (msgbuf)
		{
			DWORD res = SetDlgItemText(hwnd, kidcEdit, msgbuf);
			free(msgbuf);
		}

		return FALSE;

	case WM_COMMAND:
		switch (HIWORD(wp)) {
		case BN_CLICKED:
			// Next (OK) or Exit (Cancel) were pressed

			EndDialog(hwnd, LOWORD(wp) == IDOK);
			break;

		case EN_SETFOCUS:
			// Edit control getting the focus, make sure nothing is selected

			SendDlgItemMessage(hwnd, kidcEdit, EM_SETSEL, (WPARAM)-1, (LPARAM)-1);
			break;
		}
		break;
	}

	return FALSE;
}

BOOL WelcomeDialog()
{
	return (BOOL)DialogBox(ghInst, MAKEINTRESOURCE(kiddWelcome), NULL, (DLGPROC)WelcomeDlgProc);
}

BOOL CALLBACK EulaDlgProc(HWND hwnd, UINT wm, WPARAM wp, LPARAM lp)
{
	char *msgbuf = NULL; // GANDALF: buffer for the Welcome dialog message.

	switch (wm) {
	case WM_INITDIALOG:
		// Grab the eula.txt resource and stick it in the edit control

		// SetDlgItemText(hwnd, kidcEdit, GetTextFileResource(kidrEula));

		// GANDALF: get message from readme file.
		msgbuf = TextFromFile(".//license.txt");
		if (msgbuf)
		{
			SetDlgItemText(hwnd, kidcEdit, msgbuf);
			free(msgbuf);
		}

		return TRUE;

	case WM_COMMAND:
		switch (HIWORD(wp)) {
		case BN_CLICKED:
			// Yes (OK) or No (Cancel) were pressed

			EndDialog(hwnd, LOWORD(wp) == IDOK);
			break;

		case EN_SETFOCUS:
			// Edit control getting the focus, make sure nothing is selected

			SendDlgItemMessage(hwnd, kidcEdit, EM_SETSEL, (WPARAM)-1, (LPARAM)-1);
			break;
		}
		break;
	}

	return FALSE;
}

BOOL EulaDialog()
{
	return (BOOL)DialogBox(ghInst, MAKEINTRESOURCE(kiddEula), NULL, (DLGPROC)EulaDlgProc);
}

BYTE *GetCEAppMgrFilePtr(int idr, int *pcb)
{
	HRSRC hr = FindResource(NULL, MAKEINTRESOURCE(idr), MAKEINTRESOURCE(kidtCEAPPMGRFILES));
	if (hr == NULL)
		return NULL;
	*pcb = SizeofResource(NULL, hr);
	HGLOBAL h = LoadResource(NULL, hr);
	return (BYTE *)LockResource(h);
}

bool GetStringFromResource(int idt, int idr, char *psz, int cb)
{
	HRSRC hr = FindResource(NULL, MAKEINTRESOURCE(idr), MAKEINTRESOURCE(idt));
	if (hr == NULL)
		return false;
	int cbRes = SizeofResource(NULL, hr);
	HGLOBAL h = LoadResource(NULL, hr);
	char *pszRes = (char *)LockResource(h);

	while (cb-- != 0) {
		*psz++ = *pszRes;
		if (*pszRes++ == 0)
			break;
	}
	return true;
}

// This function saves a resource from the CEAPPMGRFILES type and saves it as a file
// in the directory szDir. The filename of the file is taking from the String Table
// with the same resource id.
//
// NOTE: A nice feature would be if the bits in CEAPPMGRFILES were compressed. This function
// would be the one to modify to decompress the bits into a file.

BOOL SaveCEAppMgrResToFile(int idr, char *pszDir, BOOL *pfError)
{
	*pfError = FALSE;

	// Get the byte pointer to the bits for this file. If none, we're done.

	int cb;
	BYTE *pb = GetCEAppMgrFilePtr(idr, &cb);
	if (pb == NULL)
		return FALSE;

	// Get the filename of these bits

	char szFn[MAX_PATH];
	if (!GetStringFromResource(kidtCEAPPMGRFILENAMES, idr, szFn, sizeof(szFn))) {
		*pfError = TRUE;
		return FALSE;
	}

	// Create the fully qualified path

	char szFullFn[MAX_PATH];
	lstrcpy(szFullFn, pszDir);
	lstrcat(szFullFn, "\\");
	lstrcat(szFullFn, szFn);

	// Create the file and write these bytes

	HANDLE h = CreateFile(szFullFn, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
	if (h == INVALID_HANDLE_VALUE) {
		*pfError = TRUE;
		return FALSE;
	}
	int cbWritten = 0;
	if (!WriteFile(h, pb, cb, (DWORD *)&cbWritten, NULL) || cb != cbWritten) {
		*pfError = TRUE;
		return FALSE;
	}
	CloseHandle(h);

	return TRUE;
}

void InstallApp()
{
	// Find the "Windows CE Services" directory. First find the CEAppMgr.exe path.

	LRESULT lr;
	HKEY hkey;

	lr = RegOpenKeyEx(HKEY_LOCAL_MACHINE, "Software\\Microsoft\\Windows\\CurrentVersion\\App Paths\\CEAPPMGR.EXE", 0, KEY_QUERY_VALUE, &hkey);
	if (lr != ERROR_SUCCESS) {
Error:
		// Error!

		MessageBox(NULL, "Windows CE Services not found on this computer. Setup cannot continue and will now exit.", "Setup", MB_OK);
		return;
	}

	// Grab the path string

	char szFnAppMgrExe[MAX_PATH];
	DWORD cb;
	cb = sizeof(szFnAppMgrExe);
	lr = RegQueryValueEx(hkey, "", 0, NULL, (BYTE *)szFnAppMgrExe, &cb);
	if (lr != ERROR_SUCCESS)
		goto Error;
	RegCloseKey(hkey);

	// Strip the directory portion off; this is the install directory

	char szDir[MAX_PATH];
	lstrcpy(szDir, szFnAppMgrExe);
	char *pchBack = NULL;
	for (char *pch = szDir; *pch != 0; pch++) {
		if (*pch == '\\')
			pchBack = pch + 1;
	}
	if (pchBack == NULL)
		goto Error;
	*pchBack = 0;


	// Grab the install directory

	char szDirName[80];
	szDirName[0] = 0;
	GetStringFromResource(kidtMISCSTRINGS, kidrDirectory, szDirName, sizeof(szDirName));
	// Gandalf: we are going to hardcode our ActiveSync App Directory
	lstrcat(szDir, "iMame"); 
	// lstrcat(szDir, szDirName);



	// Try to make this directory

	if (!CreateDirectory(szDir, NULL)) {
		if (GetLastError() != ERROR_ALREADY_EXISTS) {
			// Failed creating the directory! Strange error... Assume the path is invalid,
			// probably the directory name from the string table is wrong.

			MessageBox(NULL, "Could not create install directory. Setup cannot continue and will exit.", szDir, MB_OK);
			return;
		}
	}


	// Install directory created... now copy the install files into it
#if USED
	BOOL fError;
	int i = 1;
	while (SaveCEAppMgrResToFile(i, szDir, &fError))
		i++;
	if (fError) {
		// Error occured while saving to disk!

		MessageBox(NULL, "An error occured writing your Windows CE application to disk. Setup cannot continue and will exit.", szDir, MB_OK);
		return;
	}
#endif // GANDALF: this is not for us!

#if USED // if extracting directly to the Target Directory, you don't need this.
	// Gandalf: since we have simple used a self-extractor to get our files, and not
	// from compressed resources as Scott had done, we need to move the files from the
	// currrent directory to the Active Sync directory.
	char szTarget[MAX_PATH];
	int res = 1;
    // we shouldn't actually need this, the files should be in the current directory.
    GetCurrentDirectory(MAX_PATH, szDirName);

	wsprintf(szTarget, "%s\\imame.ppc30_arm.CAB", szDir);
	DeleteFile(szTarget);
	if ( !MoveFile(".\\imame.ppc30_arm.CAB", szTarget ) ) res = 0;
	wsprintf(szTarget, "%s\\imame.ini", szDir);
	DeleteFile(szTarget);
	if ( !MoveFile(".\\imame.ini", szTarget ) ) res = 0;
	wsprintf(szTarget, "%s\\imame.txt", szDir);
	DeleteFile(szTarget);
	if ( !MoveFile(".\\imame.txt", szTarget ) ) res = 0;

//res = GetLastError();
	if (!res)
	{
		MessageBox(NULL, "An error occured writing your Windows CE application to disk. Setup cannot continue and will exit.", szDir, MB_OK);
		return;
	}
#endif

	// Get the full path and filename to the .ini file

	char szIniFile[MAX_PATH];
	lstrcpy(szIniFile, "\"");
	lstrcat(szIniFile, szDir);
	lstrcat(szIniFile, "\\");
	int cch = lstrlen(szIniFile);
#if USED // GANDALF
	if (!GetStringFromResource(kidtCEAPPMGRFILENAMES, kidrIniFile, &szIniFile[cch], sizeof(szIniFile) - cch)) {
		// Coulding find the kidsIniFile resource

		MessageBox(NULL, "The setup files are missing information. Setup cannot continue and will exit.", "Setup", MB_OK);
		return;
	}
#endif // GANDALF
	lstrcat(szIniFile, "imame.ini\""); // GANDALF: lstrcat(szIniFile, "\"");


	// WinExec it

	char szCmdLine[MAX_PATH];
	lstrcpy(szCmdLine, szFnAppMgrExe);
	lstrcat(szCmdLine, " ");
	lstrcat(szCmdLine, szIniFile);
	WinExec(szCmdLine, SW_SHOW);
}

void main()
{
	if (!WelcomeDialog())
		return;
	if (!EulaDialog())
		return;
	InstallApp();
}



// Give us visibility in sfxwiz.c
extern "C" void GetActiveSyncDirectory(char *szDir);

// GANDALF: this is provided so that SfxWiz can show the target 
// directory for Active Sync Applications in the unzip dialog.
void GetActiveSyncDirectory(char *szDir)
{
	// Find the "Windows CE Services" directory. First find the CEAppMgr.exe path.

	LRESULT lr;
	HKEY hkey;

	lr = RegOpenKeyEx(HKEY_LOCAL_MACHINE, "Software\\Microsoft\\Windows\\CurrentVersion\\App Paths\\CEAPPMGR.EXE", 0, KEY_QUERY_VALUE, &hkey);
	if (lr != ERROR_SUCCESS) {
Error:
		// Error!

		MessageBox(NULL, "Windows CE Services not found on this computer. Setup cannot continue and will now exit.", "Setup", MB_OK);
		return;
	}

	// Grab the path string

	char szFnAppMgrExe[MAX_PATH];
	DWORD cb;
	cb = sizeof(szFnAppMgrExe);
	lr = RegQueryValueEx(hkey, "", 0, NULL, (BYTE *)szFnAppMgrExe, &cb);
	if (lr != ERROR_SUCCESS)
		goto Error;
	RegCloseKey(hkey);

	// Strip the directory portion off; this is the install directory

//	char szDir[MAX_PATH];
	lstrcpy(szDir, szFnAppMgrExe);
	char *pchBack = NULL;
	for (char *pch = szDir; *pch != 0; pch++) {
		if (*pch == '\\')
			pchBack = pch + 1;
	}
	if (pchBack == NULL)
		goto Error;
	*pchBack = 0;


	// Grab the install directory

//	char szDirName[80];
//	szDirName[0] = 0;
//	GetStringFromResource(kidtMISCSTRINGS, kidrDirectory, szDirName, sizeof(szDirName));
	// Gandalf: we are going to hardcode our ActiveSync App Directory
	lstrcat(szDir, "iMame"); 
	// lstrcat(szDir, szDirName);
}



// GANDALF: open the named text file, return a buffe to it's contents.
// Caller must free the buffer.
char *TextFromFile(char *szFnm)
{
	DWORD bytesread;
	char *msgbuf = NULL;
	char szFullFn[MAX_PATH];
	HANDLE h;

	// We must assume that the text file was unzipped into the Target Directory.
	GetActiveSyncDirectory(szFullFn);
	lstrcat(szFullFn, "\\");
	lstrcat(szFullFn, szFnm);
		
	h = CreateFile(szFullFn, GENERIC_READ, 0, NULL, OPEN_EXISTING, 
		FILE_ATTRIBUTE_NORMAL, NULL);

	if (h != INVALID_HANDLE_VALUE)
	{
		DWORD fsize = GetFileSize(h, NULL);
		msgbuf = (char *)malloc(fsize + 1);
		ReadFile(h, msgbuf, fsize, &bytesread, NULL);
		msgbuf[fsize] = '\0';
		CloseHandle(h);
	}

	return msgbuf;
}


