/***************************************************************************

    M.A.M.E.CE  -  Multiple Arcade Machine Emulator for WinCE
    Win32 Portions Copyright (C) 1997-98 Michael Soderstrom and Chris Kirmse
	WinCE Portions Copyright (C) 1999 Benjamin Cooley
    
    This file is part of MAMECE, and may only be used, modified and
    distributed under the terms of the MAME license, in "readme.txt".
    By continuing to use, modify or distribute this file you indicate
    that you have read the license and understand and accept it fully.

 ***************************************************************************/

/***************************************************************************

  Cgamex.c: AUG00 - Gandalf - modified for use with GAPI, it won't integrate directly with C,  (C++ only)

 ***************************************************************************/

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <windowsx.h>
#include <gx.h> //#include <gamex.h>

#ifndef VK_0
#define VK_0 0x30
#define VK_1 0x31
#define VK_2 0x32
#define VK_3 0x33
#define VK_4 0x34
#define VK_5 0x35
#define VK_6 0x36
#define VK_7 0x37
#define VK_8 0x38
#define VK_9 0x39
#endif

#define VK_CASSIOPEIA_SLIDER	0x86
#define VK_CASSIOPEIA_ESC		0x87
#define VK_CASSIOPEIA_REC		0xC1
#define VK_CASSIOPEIA_B1		0xC2
#define VK_CASSIOPEIA_B2		0xC3
#define VK_CASSIOPEIA_B3		0xC4

/***************************************************************************
    Function prototypes
 ***************************************************************************/

extern "C" {

BOOL		    GAMEX_Init(HWND hWnd);
void			GAMEX_Close();
void*			GAMEX_GetFBAddress();
int				GAMEX_GetFBModulo();
int				GAMEX_GetFBBpp();
void *			GAMEX_BeginDraw();
BOOL			GAMEX_EndDraw();
BOOL			GAMEX_GetScreenRect(RECT *prc);
SHORT			GAMEX_GetAsyncKeyState(int key);
int				GAMEX_GetFByPitch();
int				GAMEX_GetFBxPitch();
int				GAMEX_Suspend();
int				GAMEX_Resume();
}

/***************************************************************************
    Internal structures
 ***************************************************************************/


/***************************************************************************
    Internal variables
 ***************************************************************************/

/* our dialog/configured options */
// static GameX *gpgmx;
GXDisplayProperties g_gxdp;    // GN: GX struct
GXKeyList g_gxkl;              // GX struct


/***************************************************************************
    Internal functions
 ***************************************************************************/

/***************************************************************************
    External functions  
 ***************************************************************************/

BOOL GAMEX_Init(HWND hWnd)
{
	DWORD dwError;
	if (GXOpenDisplay( hWnd, GX_FULLSCREEN) == 0 ) 
	{
		dwError = GetLastError();
	    return FALSE;   // we won't be able to draw.
    }

	if ( GXOpenInput() == 0 )
	{
		return FALSE;
	}

	// Get the Display properties
	g_gxdp = GXGetDisplayProperties();
	// Get information about the Hardware Keys and fills
	// the g_gxkl structure
	g_gxkl = GXGetDefaultKeys(GX_NORMALKEYS);


	return TRUE;
}


void GAMEX_Close()
{
	int res;
	res = GXCloseDisplay();
	res = GXCloseInput();
}


int	GAMEX_Suspend()
{
	return GXSuspend();
}


int	GAMEX_Resume()
{
	return GXResume();
}


void* GAMEX_GetFBAddress()
{
	void *ptr = GXBeginDraw();
	return ptr;
}


int	GAMEX_GetFBModulo()
{
	return 0;
}


int	GAMEX_GetFByPitch()
{
	return g_gxdp.cbyPitch;
}


int	GAMEX_GetFBxPitch()
{
	return g_gxdp.cbxPitch;
}


int	GAMEX_GetFBBpp()
{
	return g_gxdp.cBPP;
}


int	GAMEX_GetFBformat()
{
	return g_gxdp.ffFormat;
}


void* GAMEX_BeginDraw()
{
	return GXBeginDraw();
}


BOOL GAMEX_EndDraw()
{
	return GXEndDraw();
}


BOOL GAMEX_GetScreenRect(RECT *prc)
{
	prc->bottom = g_gxdp.cyHeight;
	prc->right = g_gxdp.cxWidth;
	return 0;
}


SHORT GAMEX_GetAsyncKeyState(int key)
{
	int newkey = key;

#ifdef CASSIOPEIA_E100
	switch (key)
	{
	  case VK_1:			newkey = VK_CASSIOPEIA_B1; break;
	  case VK_2:			newkey = VK_CASSIOPEIA_B2; break;
	  case VK_3:			newkey = VK_CASSIOPEIA_SLIDER; break;
	  case VK_ESCAPE:		newkey = VK_CASSIOPEIA_ESC; break;
	  case VK_TAB:			newkey = VK_CASSIOPEIA_REC; break;
	  case VK_LCONTROL:		newkey = VK_CASSIOPEIA_B1; break;
	  case VK_RETURN:		newkey = VK_CASSIOPEIA_B1; break;
	  case VK_MENU:			newkey = VK_CASSIOPEIA_B2; break;
	  case VK_SPACE:		newkey = VK_CASSIOPEIA_B3; break;
	}
#endif

	return GetAsyncKeyState(newkey);
}
