// game_info.c
// SEP00 - Gandalf
#include <windows.h>
#include <stdio.h>

#include "resource.h"
#include "driver.h"
#include "game_info.h"
#include "basename.h"
#include "file.h" // the file types, e.g. OSD_FILETYPE_ROM

// local functions
static char *GetRomList(int);
static char *GetSampleList(int);
static /* INT_PTR*/ long CALLBACK GameInfoDialogProc(HWND, UINT, WPARAM, LPARAM);
static void ListAddItems( HWND hwndInfolist, char *(*ListFunction)(int) );

// local variables
static int m_Playgame;


extern HWND      g_hUIwnd;



/////////////////////////////
void ShowGameInfo(int game)
{
	if (game < 0)
	{
		return;
	}

	m_Playgame = game;

	DialogBox(GetModuleHandle(NULL),
		MAKEINTRESOURCE(IDD_MAMEINFO), 
		NULL, GameInfoDialogProc);
}



//////////////////////////////////////////
static /* INT_PTR*/ long CALLBACK GameInfoDialogProc(HWND hDlg, UINT Msg, WPARAM wParam, LPARAM lParam)
{
	static HWND hwndInfolist;
	TCHAR titlemsg[100];
	TCHAR infomsg[100];
	static dlgno = 0;
	char buf[200];
	HWND hwndInfomsg = GetDlgItem(hDlg, IDC_INFO);
	RECT tRect;
	
    switch (Msg)
    {
    case WM_INITDIALOG:
		GetClientRect(g_hUIwnd, &tRect);
		MoveWindow( hDlg, tRect.left, tRect.top, 
			tRect.right-tRect.left,tRect.bottom - tRect.top, TRUE);

        mysprintf(titlemsg,"%s", drivers[m_Playgame]->description);
        mysprintf(infomsg,
			"\"%s\" requires the following Rom images to be present in \"%s%s\":",
			drivers[m_Playgame]->name, g_romdir, drivers[m_Playgame]->name);

		SetDlgItemText(hDlg, IDC_TITLE, titlemsg );
		SetDlgItemText(hDlg, IDC_INFO, infomsg );
		
		/* Setup Rom list display */
		hwndInfolist = GetDlgItem(hDlg, IDC_INFO_DETAILS);

		ListAddItems(hwndInfolist, &GetRomList );

        return 1;
		
    case WM_COMMAND :
		if (LOWORD(wParam) == IDOK)
		{
			switch(dlgno)
			{
			case 0:
				mysprintf(infomsg,
					"\"%s\" will use the following Sample files from \"%s%s\":",
					drivers[m_Playgame]->name, g_samdir, drivers[m_Playgame]->name);
				
				SetDlgItemText(hDlg, IDC_INFO, infomsg );
				
				/* Setup Rom list display */
				ListAddItems(hwndInfolist, &GetSampleList );
				dlgno++;
				break;

			case 1:
				ShowWindow(hwndInfolist, SW_HIDE);
				SetDlgItemText(hDlg, IDOK, TEXT("OK") );

				GetWindowRect(hwndInfomsg, &tRect);
				SetWindowPos(hwndInfomsg, HWND_TOP, // topmost
					0, 0, // tRect.left, tRect.top, // x, y
					tRect.right - tRect.left, // width
					( tRect.bottom - tRect.top ) + 20, // height + 20
					SWP_NOMOVE); // retains x and y

				strcpy(buf,"THE FOLLOWING PEOPLE CONTRIBUTED TO THIS DRIVER:\n\n");
				if ( drivers[m_Playgame]->credits )
				{
					strcat(buf,drivers[m_Playgame]->credits);
				}

				mysprintf(infomsg, "%s", buf);
				
				SetDlgItemText(hDlg, IDC_INFO, infomsg );
				
				/* Setup Rom list display */
				ListAddItems(hwndInfolist, &GetSampleList );
				dlgno++;
				break;
				
			case 2:
				dlgno = 0;
	            EndDialog(hDlg,1);
				break;
			default:
				break;
			} // end switch
		}
		return 1;

	case WM_CLOSE:
        EndDialog(hDlg,1);
		return 1;
	}
    return 0;
}


//////////////////////////////////////////
static char *GetRomList(int iGame)
{
    static char buf[5000];
    const struct RomModule *romp =  drivers[iGame]->rom;

    buf[0] = '\0';

    if (NULL == romp) return 0;

    while (romp->name || romp->offset || romp->length)
    {
		if (romp->length == 0)
		{
			sprintf(buf + strlen(buf), "Region 0x%x\n", romp->offset);
		}

        romp++; /* skip memory region definition */
        
        while (romp->length)
        {
			FILE *f;
			char tmp[100];
            char name[100];
            int length;
            
            sprintf(name, "%s", romp->name);
            length = 0;
            
            do
            {
                /* ROM_RELOAD */
                if (romp->name == (char *)-1)
                    length = 0; /* restart */
                
//                length += romp->length & ~ROMFLAG_MASK;
                
                romp++;

            } while (romp->length && (romp->name == 0 || romp->name == (char *)-1));
            
//            sprintf(buf + strlen(buf), "%s:\t%-12s\t%u bytes\r\n", drivers[iGame]->name, name, length);

			sprintf(tmp, "%s\\%s\\%s", g_romdir /* g_basename */, drivers[iGame]->name, name);

//			if ( f = fopen(tmp, "rb") )
            if ( f = osd_fopen(drivers[iGame]->name, name, OSD_FILETYPE_ROM, 0) )
			{
				sprintf(buf + strlen(buf), "+ %s\n", name);
//				fclose(f);
				osd_fclose(f);
			}
			else
			{
				sprintf(buf + strlen(buf), "- %s\n", name);
			}
        }
    }

    return buf;
}


//////////////////////////////////////////
static char *GetSampleList(int iGame)
{
    static char buf[5000];
	char **samplenames = drivers[iGame]->samplenames;
	int i = 0;
    buf[0] = '\0';

    if (NULL == samplenames) return 0;

	while (samplenames[i] != 0) 
	{
		if (samplenames[i][0])
		{
			char tmp[100];
			FILE *f;

			sprintf(tmp, "%s\\%s\\%s", g_samdir /* g_basename */, drivers[iGame]->name, samplenames[i]);

//			if ( f = fopen(tmp, "rb") )
            if (f = osd_fopen(drivers[iGame]->name, samplenames[i], OSD_FILETYPE_SAMPLE, 0) )
			{
				sprintf(buf + strlen(buf), "+ %s\n", samplenames[i]);
//				fclose(f);
				osd_fclose(f);
			}
			else
			{
				sprintf(buf + strlen(buf), "- %s\n", samplenames[i]);
			}
        }
		i++;
    }

    return buf;
}


//////////////////////////////////////////
static void ListAddItems(HWND hwndInfolist, char *(*ListFunction)(int) )
{
	char itemname[50];
	char *itemlist;
	char *token;
	int i;

	int lbcount = SendMessage(hwndInfolist, LB_GETCOUNT, 0, 0);

	for (i = lbcount; i > 0; i--)
	{
		int res = SendMessage(hwndInfolist, LB_DELETESTRING, i - 1, 0);
	}

	itemlist = (*ListFunction)(m_Playgame);

	if (itemlist)
	{
		token = strtok(itemlist, "\n");
		
		while( token != NULL )
		{
			mysprintf(itemname, "%s", token);
			SendMessage(hwndInfolist, LB_ADDSTRING, 0, (WPARAM)itemname );
			token = strtok( NULL, "\n" );
		}
	}
}


//////////////////////////////////////////
void __cdecl mysprintf(TCHAR *in, char *fmt,...)
{
   char s[500];
   va_list marker;
   va_start(marker,fmt);

   vsprintf(s,fmt,marker);

#ifdef UNICODE
   wsprintf(in, TEXT("%S"), s);
#else
   sprintf(in, "%s", s);
#endif

   va_end(marker);
}




/////////////////////////////////////////////////////////////
DWORD /* WINAPI */ MakeGameList(HWND hwndList /* void */)
{
	TCHAR buf[100];

	/* Initialize game list */
    int gamecount = 0;
    while (drivers[gamecount] != 0)
	{
		mysprintf(buf, "%s", drivers[gamecount]->name );

		SendMessage(hwndList, LB_ADDSTRING, 0, (WPARAM)buf);
        gamecount++;
	}
//	g_hThread = NULL;

	// This locks out cursor pad control on game selection list box, 
	// until you run a game and come back: what the fuck?
	SendMessage(hwndList, LB_SETSEL, TRUE, 0);


	return TRUE;
}
