// mame_wnd.c
// AUG00 - Gandalf: borrowed some code from Mame32V36

#include <windows.h>

//#include "keycode.h"
extern byte key[];

static LRESULT CALLBACK MAME32_MessageProc(HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam);
void osd_win32_OnPaint(HWND hWnd);
int Win32KeyToOSDKey(UINT vk);

/***************************************************************************/

/* static */ HWND MAME32_CreateWindow(void)
{
    static BOOL     bRegistered = FALSE;
    HINSTANCE       hInstance = GetModuleHandle(NULL);

    if (bRegistered == FALSE)
    {
        WNDCLASS    WndClass;

        WndClass.style          = 0; // GN // CS_SAVEBITS | CS_BYTEALIGNCLIENT | CS_OWNDC;
        WndClass.lpfnWndProc    = MAME32_MessageProc;
        WndClass.cbClsExtra     = 0;
        WndClass.cbWndExtra     = 0;
        WndClass.hInstance      = hInstance;
        WndClass.hIcon          = NULL; // GN // LoadIcon(hInstance, MAKEINTATOM(IDI_MAME32_ICON));
        WndClass.hCursor        = LoadCursor(NULL, IDC_WAIT); // GN // LoadCursor(NULL, IDC_ARROW);
        WndClass.hbrBackground  = (HBRUSH)GetStockObject(NULL_BRUSH);
        WndClass.lpszMenuName   = NULL;
        WndClass.lpszClassName  = TEXT("classMAME32"); // GN // (LPCSTR)"classMAME32";
        
        if (RegisterClass(&WndClass) == 0)
            return NULL;
        bRegistered = TRUE;
    }

    return CreateWindowEx(0,
                          TEXT("classMAME32"), // GN // "classMAME32",
                          TEXT("Mame32"), // GN // MAME32App.m_Name,
                          WS_VISIBLE, // WS_OVERLAPPED | WS_SYSMENU, // GN // WS_OVERLAPPEDWINDOW & ~WS_THICKFRAME | WS_BORDER,
                          CW_USEDEFAULT,
                          CW_USEDEFAULT,
                          CW_USEDEFAULT,
                          CW_USEDEFAULT,
//                          0, 0,
                          NULL,
                          NULL,
                          hInstance,
                          NULL);
}


/***************************************************************************/

static LRESULT CALLBACK MAME32_MessageProc(HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam)
{
    LRESULT Result = 0;
	
    switch (Msg)
    {
//	case WM_KILLFOCUS:

	case WM_CLOSE:
		/* Don't call DestroyWindow, it will be called by osd_exit. */
		return 0;
		break;
#ifndef GAMEX		
	case WM_PAINT:
		osd_win32_OnPaint(hWnd);
		return 0;
		break;
#endif		
	case WM_KEYUP :
		if (Win32KeyToOSDKey(wParam) != 0)
		{
			key[Win32KeyToOSDKey(wParam)] = 0;
		}
		break;
		
	case WM_KEYDOWN:
		
		if (Win32KeyToOSDKey(wParam) != 0)
		{
			key[Win32KeyToOSDKey(wParam)] = 1;
		}
		break;
		
	case WM_SYSKEYDOWN :
		if (wParam == VK_MENU)
		{
			/* stupid alt key! */
			if (Win32KeyToOSDKey(wParam) != 0)
				key[Win32KeyToOSDKey(wParam)] = 1;
			return 0;
		}
		break;
		
	case WM_SYSKEYUP :
		if (wParam == VK_MENU)
		{
			/* stupid alt key! */
			if (Win32KeyToOSDKey(wParam) != 0)
				key[Win32KeyToOSDKey(wParam)] = 0;
			return 0;
		}
		break;
		
	}
    return DefWindowProc(hWnd, Msg, wParam, lParam);
}

