/*---------------------------------------------
   dirlist.c -- 9/00: Gandalf
   Creates a listbox/combobox mechanism for browsing 
   the available directories on the system, returning the chosen
   directory.to the caller.
   This module is UNICODE compatible, portable to WinCE.
  ---------------------------------------------*/

#include <windows.h>
#include <stdio.h>
#include <tchar.h>
#include <stdlib.h>


#define ID_LIST         1
#define ID_TEXT         2
#define ID_COMBO        3
#define ID_OKBTN        4
#define ID_CANCELBTN    5


static LRESULT CALLBACK WndProc  (HWND, UINT, WPARAM, LPARAM);
static LRESULT CALLBACK ListProc (HWND, UINT, WPARAM, LPARAM);


static BOOL MameGetRegString(char *, TCHAR *);
static void Combo_Build(TCHAR *);
static void Directory_List(TCHAR *);
static void Combo_GetDir(TCHAR *, int);
static void MameWriteRegString(TCHAR *, TCHAR *);
static BOOL Reg_ReadString(TCHAR *, TCHAR *);
static HKEY MameCreateKey(void);


static WNDPROC m_OldList;
static HINSTANCE m_hInstance;
static TCHAR m_szAppName[MAX_PATH];
static HWND m_hwndList, m_hwndText, m_hwndCombo, 
       m_hwndOkBtn, m_hwndCancelBtn;


// GN: FTEST
char  g_romdir[MAX_PATH];
char  g_samdir[MAX_PATH];



//////////////////////////////////////////////////////////////////////
// GN: FTEST- these two guys were in options.c
//////////////////////////////////////////////////////////////////////
const char* GetSampleDirs(void)
{
	if (FALSE == MameGetRegString(g_samdir, TEXT("Samples Directory")) )
	{
		; // nothing for now
	}

    return g_samdir;
}

const char* GetRomDirs(void)
{
	if (FALSE == MameGetRegString(g_romdir, TEXT("Roms Directory")) )
	{
		; // nothing for now
	}

    return g_romdir;
}


//////////////////////////////////////////////////////////////////////
static BOOL MameGetRegString(char *sz, TCHAR *szKey)
{
	TCHAR tmp[MAX_PATH];

	if (FALSE == Reg_ReadString(tmp, szKey) )
	{
		return FALSE;
	}

	// retrieve the path...mame expects it to be string of type char 
#ifdef _WIN32_WCE
	wcstombs(sz, tmp, MAX_PATH);
#else
	wsprintf(sz, TEXT("%s"), tmp);
#endif

	return TRUE;
}


//////////////////////////////////////////////////////////////////////
//int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
//                   LPTSTR szCmdLine, int iCmdShow)
int MameDir_Set(TCHAR *szType)
{
     HWND         hwnd;
     MSG          msg;

     HINSTANCE    hInstance = GetModuleHandle(NULL);
     static BOOL     bRegistered = FALSE;


	 wsprintf( m_szAppName, TEXT("%s Directory"), szType);

     
	 if (bRegistered == FALSE)
	 {
		 WNDCLASS     wndclass;
		 wndclass.style         = CS_HREDRAW | CS_VREDRAW;
		 wndclass.lpfnWndProc   = WndProc;
		 wndclass.cbClsExtra    = 0;
		 wndclass.cbWndExtra    = 0;
		 wndclass.hInstance     = hInstance;
		 wndclass.hIcon         = 0;
		 wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW);
		 wndclass.hbrBackground = (HBRUSH) (COLOR_BTNFACE + 1);
		 wndclass.lpszMenuName  = NULL;
		 wndclass.lpszClassName = TEXT("Mame Directory"); // m_szAppName;
		 
		 if (!RegisterClass (&wndclass))
		 {
			 return 0;
		 }
		 
		 bRegistered = TRUE;
	 }
     
	 m_hInstance = hInstance;

     hwnd = CreateWindow (TEXT("Mame Directory"), m_szAppName,
							WS_VISIBLE, // WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          NULL, NULL, hInstance, NULL);
     
     ShowWindow (hwnd, SW_SHOW);
     UpdateWindow (hwnd);
     
     while (GetMessage (&msg, NULL, 0, 0))
     {
          TranslateMessage (&msg);
          DispatchMessage (&msg);
     }

     ShowWindow (hwnd, SW_HIDE);


	 // update the global settings
	 MameGetRegString(g_romdir, TEXT("Roms Directory"));
	 MameGetRegString(g_samdir, TEXT("Samples Directory"));


     return msg.wParam;
}


//////////////////////////////////////////////////////////////////////
static LRESULT CALLBACK WndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	static RECT     rect;
	static TCHAR    szBuffer[MAX_PATH + 1];
	int             cxChar, cyChar;
	WIN32_FIND_DATA finddata;
	
	// Initialize the starting directory string
	TCHAR initpath[MAX_PATH];

	// Try to read the pertinent directory setting from registry
	Reg_ReadString(initpath, m_szAppName);
	

	wsprintf(szBuffer, TEXT("%s*.*"),initpath  ); // TEST
	
	// check if initpath exists, if not, default to "\\"
	if (INVALID_HANDLE_VALUE == FindFirstFile(szBuffer, &finddata) )
	{
		wsprintf(initpath, TEXT("\\") ); // TEST
	}
	
	
	switch (message)
	{
	case WM_CREATE :
		cxChar = LOWORD (GetDialogBaseUnits ());
		cyChar = HIWORD (GetDialogBaseUnits ());
		
		rect.left = 20 * cxChar;
		rect.top  =  3 * cyChar;
		
		m_hwndOkBtn = CreateWindow (TEXT ("button"), TEXT("OK"),
			WS_CHILD | WS_VISIBLE | BS_DEFPUSHBUTTON,
			cxChar * 4, cyChar * 17,
			55, 25,
			hwnd, (HMENU) ID_OKBTN,
			m_hInstance,
			NULL);
		
		m_hwndCancelBtn = CreateWindow (TEXT ("button"), TEXT("Cancel"),
			WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
			cxChar * 14, cyChar * 17,
			55, 25,
			hwnd, (HMENU) ID_CANCELBTN,
			m_hInstance,
			NULL);
		
		m_hwndList = CreateWindow (TEXT ("listbox"), NULL,
			WS_CHILD | WS_VISIBLE | LBS_STANDARD,
			cxChar * 2, cyChar * 5,
			cxChar * 24,
			cyChar * 12,
			hwnd, (HMENU) ID_LIST,
			m_hInstance,
			NULL);
		
		m_hwndText = CreateWindow (TEXT ("static"), NULL,
			WS_CHILD | WS_VISIBLE | SS_LEFT,
			cxChar * 2, cyChar, 
			cxChar * 28,
			cyChar,
			hwnd, (HMENU) ID_TEXT,
			m_hInstance,
			NULL);
		
		m_hwndCombo = CreateWindow (TEXT ("combobox"), NULL,
			WS_CHILD | WS_VISIBLE | CBS_DROPDOWNLIST,
			cxChar * 2, cyChar * 3, 
			cxChar * 28,
			cyChar * 5,
			hwnd, (HMENU) ID_COMBO,
			m_hInstance,
			NULL);
		
		m_OldList = (WNDPROC) SetWindowLong (m_hwndList, GWL_WNDPROC,
			(LPARAM) ListProc);
		
		Combo_Build(initpath);
		Directory_List(initpath);
		
		return 0;
		
		
	case WM_COMMAND :
		
		// Handle the OK button
		if (LOWORD (wParam) == ID_OKBTN)
		{
			int i;
			if (LB_ERR != (i = SendMessage (m_hwndCombo, CB_GETCOUNT, 0, 0)))
			{
				TCHAR path[MAX_PATH];
				Combo_GetDir(path, i );
				MameWriteRegString(path, m_szAppName);
			}
			PostQuitMessage (0);
			return 0;
		}
		
		// Handle the cancel button
		if (LOWORD (wParam) == ID_CANCELBTN)
		{
			PostQuitMessage (0);
			return 0;
		}
		
		
		// Handle the listbox
		if (LOWORD (wParam) == ID_LIST && HIWORD (wParam) == LBN_DBLCLK)
		{
			int i;
			
			if (LB_ERR == (i = SendMessage (m_hwndList, LB_GETCURSEL, 0, 0)))
			{
				break;
			}
			else
			{
				TCHAR path[MAX_PATH];
				
				SendMessage (m_hwndList, LB_GETTEXT, i, (LPARAM) szBuffer);
				
				// Append the chosen directory onto the current directory
				if (LB_ERR != (i = SendMessage (m_hwndCombo, CB_GETCOUNT, 0, 0)))
				{
					Combo_GetDir(path, i);
					wsprintf(path, TEXT("%s%s"), path, szBuffer);
					
					SendMessage (m_hwndCombo, CB_RESETCONTENT, 0, 0);
					Combo_Build(path);
					Directory_List(path);
				}
			}
		}
		
		
		// Handle the combo box
		if (LOWORD (wParam) == ID_COMBO && HIWORD (wParam) == CBN_SELCHANGE )
		{
			int i;
			
			if (LB_ERR == (i = SendMessage (m_hwndCombo, CB_GETCURSEL, 0, 0)))
			{
				break;
			}
			else
			{
				TCHAR path[MAX_PATH];
				Combo_GetDir(path, i + 1);
				SendMessage (m_hwndCombo, CB_RESETCONTENT, 0, 0);
				Combo_Build(path);
				Directory_List(path);
			}
		}
		return 0;
		
	case WM_DESTROY :
		PostQuitMessage (0);
		return 0;
     }
     return DefWindowProc (hwnd, message, wParam, lParam);
}


//////////////////////////////////////////////////////////////////////     
static LRESULT CALLBACK ListProc (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
     if (message == WM_KEYDOWN && wParam == VK_RETURN)
	 {
          SendMessage (GetParent (hwnd), WM_COMMAND, 
                       MAKELONG (1, LBN_DBLCLK), (LPARAM) hwnd);
	 }
          
     return CallWindowProc (m_OldList, hwnd, message, wParam, lParam);
}



// Add names of all directories in the current directory to the given list box.
// To darn bad the LB_DIR list box message isn't supported :(
// "dirname" is passed in as an argument so that the caller can format as needed.
static void Directory_List(TCHAR *szCurrentDir)
{
	HANDLE hf;
	TCHAR fullname[MAX_PATH];
	WIN32_FIND_DATA finddata;

	TCHAR path[MAX_PATH];
	wsprintf(path, TEXT("%s"), szCurrentDir);

	// Reset the list box
	SendMessage (m_hwndList, LB_RESETCONTENT, 0, 0);

	// Set the static text
	SetWindowText (m_hwndText, path);

	// wild card name for the current directory
	wsprintf(fullname, TEXT("%s*.*"), path);
	
	// Find the first wild card file in this directory.
	if (INVALID_HANDLE_VALUE != (hf = FindFirstFile(fullname, &finddata) ) )
	{
		DWORD res = 1;
		int cnt = 0;

		while (res)
		{
			// 95/98/NT: relative directories ".." and "." will be shown.
			// FindNextFile returns 0 when no files remain in CWD
			if( FILE_ATTRIBUTE_DIRECTORY == finddata.dwFileAttributes )
			{
				TCHAR buf[MAX_PATH];
				wsprintf(buf, TEXT("%s\\"), finddata.cFileName);
				SendMessage(m_hwndList, LB_ADDSTRING, cnt++, (WPARAM)buf);
			}
			
			// Find NextFile returns 0 when no files remain in CWD
			res = FindNextFile(hf, &finddata);
		}
	}
}


//////////////////////////////////////////////////////////////////////
static void Combo_Build(TCHAR *szCurrentDir)
{
	TCHAR *tok;
	TCHAR path[MAX_PATH];
	int res = 0;
	int ttl = 0;

	wsprintf(path, TEXT("%s"), szCurrentDir);

	// Set the root indicator into the combo box
	res = SendMessage(m_hwndCombo, CB_ADDSTRING, 0, (LPARAM)TEXT("\\") );

	tok = _tcstok(path, TEXT("\\"));

	// continue adding the rest of the directories to the combo box
	while (tok)
	{
		TCHAR buf[MAX_PATH];
		int ct = 0;
		
		// indent with spaces successively for each level deeper of directory.
		TCHAR *tmp = buf;
		*tmp = '\0';
		ttl++;
		
		for (ct = 0; ct < ttl; ct++)
		{
			_tcscat(tmp++, TEXT("   "));
		}
		
		_tcscat(tmp, tok);
		_tcscat(tmp, TEXT("\\"));
		
		res = SendMessage(m_hwndCombo, CB_ADDSTRING, 0, (LPARAM)buf);
		
		tok = _tcstok(NULL, TEXT("\\"));
	}

	SendMessage(m_hwndCombo, CB_SETCURSEL, ttl, 0);
}


//////////////////////////////////////////////////////////////////////
static void Combo_GetDir(TCHAR *path, int item)
{
	// Build the current directory from the combobox items
	// cumulative to the selection
	TCHAR buf[MAX_PATH];
	int ct = 0;

	// start with "\"
	*path = '\0';
	_tcscat(path, TEXT("\\"));
	
	for (ct = 1; ct < item; ct++)
	{
		TCHAR *tmp;

		SendMessage (m_hwndCombo, CB_GETLBTEXT, ct, (LPARAM)buf);

		// strip leading white space
		tmp = buf;
		while (*tmp == ' ')
		{
			tmp++;
		}

		// Add the this CB entry, and append with the "\"
		wsprintf(path, TEXT("%s%s"), path, tmp);
	}
}


//////////////////////////////////////////////////////////////////////
static HKEY MameCreateRegKey(void)
{
	HKEY hKey;
	unsigned long disposition;

	// Create the key (if it does not already exist
	RegCreateKeyEx( HKEY_LOCAL_MACHINE, 
	            TEXT("Software\\Gandalf\\iMame"),
				0,
				TEXT("MAME"), // this is ignored?
				REG_OPTION_NON_VOLATILE,
				KEY_ALL_ACCESS,
				NULL,
				&hKey,
				&disposition );

	//If the Key did not already exist, return True, otherwise return False
	if( disposition == REG_CREATED_NEW_KEY || REG_OPENED_EXISTING_KEY )
	{
		return hKey;
	}
}


//////////////////////////////////////////////////////////////////////
static BOOL Reg_ReadString(TCHAR *sz, TCHAR *szKey)
{
	unsigned long size = MAX_PATH;
	unsigned long type;
	HKEY hKey;
	TCHAR tmp[MAX_PATH];

	LONG res = RegOpenKeyEx( HKEY_LOCAL_MACHINE, 
	            TEXT("Software\\Gandalf\\iMame"),
				0,
				KEY_ALL_ACCESS,
				&hKey
				);

	res = RegQueryValueEx( hKey, szKey, 
		NULL, &type, // NULL if the type is not required, REG_SZ maybe?
		tmp, &size);

	wsprintf(sz, TEXT("%s"), tmp);

	if ( res != ERROR_SUCCESS )
	{
		// LoadString( NULL, DEFAULT_PATH, m_RegisteredPath, sizeof(m_RegisteredPath) );
		wsprintf(sz, TEXT("\\") );
		return FALSE;
	}

	return TRUE;
}


//////////////////////////////////////////////////////////////////////
static void MameWriteRegString(TCHAR *szPath, TCHAR *szKey)
{
	HKEY hKey = MameCreateRegKey();
	TCHAR tmp[MAX_PATH];
	int shit;
	int res;

	wsprintf(tmp, TEXT("%s"), szPath);

	// set the length of the string, and include the terminating null
#ifdef _WIN32_WCE
	shit = (_tcslen(tmp) + 1) * 2; // stupid unicode string
#else
	shit = _tcslen(tmp) + 1;
#endif

	res = RegSetValueEx( hKey, szKey, 0, REG_SZ, tmp, shit );
}

