/***************************************************************************

  AUG00 - shamelessly stolen, hacked, mutilated
  from Mame32 v27 and (bits of) v36 by Gandalf.

  win32.c

  OS dependant stuff (display handling, keyboard scan...)
  This is the only file which should me modified in order to port the
  emulator to a different system.

  Created 6/29/97 by Christopher Kirmse (ckirmse@ricochet.net)

  Although MAME isn't ideally suited to the event driven windows model,
  we can poll for events on a regular basis (because the main loop calls
  us to check for keys all the time).  This makes the Windows version
  run quite well, and reduces many hardware compatibility problems!

***************************************************************************/

#include <windows.h>
#include "file.h"
#include "driver.h"
#include "dirent.h"
#include "cesound.h"
#include "sndintrf.h"
#include "samples.h"
#include "mame_wnd.h"
#ifdef GAMEX
#include "cgamex.h"
#endif



// Forward declarations

// for Mame30
char *get_config_string(char *type, char *token, char *value);
void set_config_file (char *file);
int get_config_int(char *type, char *token, int def_value);
int osd_obtain_pen(unsigned char red, unsigned char green, unsigned char blue);


#ifdef GAMEX
void DrawScreen(void);
void ClearScreen(void);
int m_firsttime = TRUE;
#endif

int Win32KeyToOSDKey(UINT vk);

#ifdef _WIN32_WCE
DWORD timeGetTime(VOID); // this piece of junk is from ce_syms.c
#endif

// forward declarations...defined in mame.c
int init_machine(const char *gamename,int argc,char **argv);
void shutdown_machine(void);
int run_machine(const char *gamename);



/* display related stuff */
int video_sync;
struct osd_bitmap *bitmap;
int g_ShowFPS;


unsigned short *m_pusLine = NULL; // GN: test


typedef struct
{
    DWORD m_Top;
    DWORD m_Left;
    DWORD m_Right;  
    DWORD m_Bottom; 
	DWORD m_Width;
	DWORD m_Height;
} tRect;



#define OSD_NUMPENS         (256)

static struct osd_bitmap*   m_pMAMEBitmap;
static int                  m_pencount = 0;
static int                  m_first_free_pen;
static HWND                 m_hAppWnd;
static tRect                m_VisibleRect;
static tRect                m_DisplayRect;

#ifdef GAMEX

static WORD                 m_palette2[OSD_NUMPENS];
static int                  m_bpp;
static RECT                 m_screenrect;
static int                  m_pitchX;
static int                  m_pitchY;

#else // not GAMEX

static HDC					m_hMemDC;
static BITMAPINFO*          m_pInfo;
static HBITMAP				m_hBitmap;
static HBITMAP				m_hOldBitmap;
#endif


/* audio related stuff */
int play_sound = 1;
unsigned char No_FM = 1; // GN: Mame30

#define NUMVOICES 8


/*
 *   Trackball Related stuff
 * not supported yet, but working on it!
 */

int        mouse_x,mouse_y;
static int use_trak = 0;
static int large_trak_x = 0;
static int large_trak_y = 0;



/* keyboard related stuff */

#ifndef OSD_KEY_NONE
#define OSD_KEY_NONE	0
#endif
#define OSD_NUMKEYS		(100)


/* static */ int key_code_table[] = {

/*                   0x00 */ OSD_KEY_NONE,
/* VK_LBUTTON        0x01 */ OSD_KEY_NONE,
/* VK_RBUTTON        0x02 */ OSD_KEY_NONE,
/* VK_CANCEL         0x03 */ OSD_KEY_NONE,
/* VK_MBUTTON        0x04 */ OSD_KEY_NONE,
/*                   0x05 */ OSD_KEY_NONE,
/*                   0x06 */ OSD_KEY_NONE,
/*                   0x07 */ OSD_KEY_NONE,
/* VK_BACK           0x08 */ OSD_KEY_BACKSPACE,
/* VK_TAB            0x09 */ OSD_KEY_TAB,
/*                   0x0A */ OSD_KEY_NONE,
/*                   0x0B */ OSD_KEY_NONE,
/* VK_CLEAR          0x0C */ OSD_KEY_5_PAD,
/* VK_RETURN         0x0D */ OSD_KEY_ENTER,
/*                   0x0E */ OSD_KEY_NONE,
/*                   0x0F */ OSD_KEY_NONE,
/* VK_SHIFT          0x10 */ OSD_KEY_LSHIFT,
/* VK_CONTROL        0x11 */ OSD_KEY_CONTROL,
// /* VK_CONTROL        0x11 */ OSD_KEY_LCONTROL, // GN: V30
/* VK_MENU           0x12 */ OSD_KEY_ALT,
/* VK_PAUSE          0x13 */ OSD_KEY_NONE,
/* VK_CAPITAL        0x14 */ OSD_KEY_CAPSLOCK,
/*                   0x15 */ OSD_KEY_NONE,
/*                   0x16 */ OSD_KEY_NONE,
/*                   0x17 */ OSD_KEY_NONE,
/*                   0x18 */ OSD_KEY_NONE,
/*                   0x19 */ OSD_KEY_NONE,
/*                   0x1A */ OSD_KEY_NONE,
/* VK_ESCAPE         0x1B */ OSD_KEY_ESC,
/*                   0x1C */ OSD_KEY_NONE,
/*                   0x1D */ OSD_KEY_NONE,
/*                   0x1E */ OSD_KEY_NONE,
/*                   0x1F */ OSD_KEY_NONE,
/* VK_SPACE          0x20 */ OSD_KEY_SPACE,
/* VK_PRIOR          0x21 */ OSD_KEY_PGUP,
/* VK_NEXT           0x22 */ OSD_KEY_PGDN,
/* VK_END            0x23 */ OSD_KEY_END,
/* VK_HOME           0x24 */ OSD_KEY_HOME,
/* VK_LEFT           0x25 */ OSD_KEY_LEFT,
/* VK_UP             0x26 */ OSD_KEY_UP,
/* VK_RIGHT          0x27 */ OSD_KEY_RIGHT,
/* VK_DOWN           0x28 */ OSD_KEY_DOWN,
/* VK_SELECT         0x29 */ OSD_KEY_NONE,
/* VK_PRINT          0x2A */ OSD_KEY_NONE,
/* VK_EXECUTE        0x2B */ OSD_KEY_NONE,
/* VK_SNAPSHOT       0x2C */ OSD_KEY_NONE,
/* VK_INSERT         0x2D */ OSD_KEY_INSERT,
/* VK_DELETE         0x2E */ OSD_KEY_DEL,
/* VK_HELP           0x2F */ OSD_KEY_NONE,
/*                   '0'  */ OSD_KEY_0,
/*                   '1'  */ OSD_KEY_1,
/*                   '2'  */ OSD_KEY_2,
/*                   '3'  */ OSD_KEY_3,
/*                   '4'  */ OSD_KEY_4,
/*                   '5'  */ OSD_KEY_5,
/*                   '6'  */ OSD_KEY_6,
/*                   '7'  */ OSD_KEY_7,
/*                   '8'  */ OSD_KEY_8,
/*                   '9'  */ OSD_KEY_9,
/*                   0x3A */ OSD_KEY_NONE,
/*                   0x3B */ OSD_KEY_NONE,
/*                   0x3C */ OSD_KEY_NONE,
/*                   0x3D */ OSD_KEY_NONE,
/*                   0x3E */ OSD_KEY_NONE,
/*                   0x3F */ OSD_KEY_NONE,
/*                   0x40 */ OSD_KEY_NONE,
/*                   'A'  */ OSD_KEY_A,
/*                   'B'  */ OSD_KEY_B,
/*                   'C'  */ OSD_KEY_C,
/*                   'D'  */ OSD_KEY_D,
/*                   'E'  */ OSD_KEY_E,
/*                   'F'  */ OSD_KEY_F,
/*                   'G'  */ OSD_KEY_G,
/*                   'H'  */ OSD_KEY_H,
/*                   'I'  */ OSD_KEY_I,
/*                   'J'  */ OSD_KEY_J,
/*                   'K'  */ OSD_KEY_K,
/*                   'L'  */ OSD_KEY_L,
/*                   'M'  */ OSD_KEY_M,
/*                   'N'  */ OSD_KEY_N,
/*                   'O'  */ OSD_KEY_O,
/*                   'P'  */ OSD_KEY_P,
/*                   'Q'  */ OSD_KEY_Q,
/*                   'R'  */ OSD_KEY_R,
/*                   'S'  */ OSD_KEY_S,
/*                   'T'  */ OSD_KEY_T,
/*                   'U'  */ OSD_KEY_U,
/*                   'V'  */ OSD_KEY_V,
/*                   'W'  */ OSD_KEY_W,
/*                   'X'  */ OSD_KEY_X,
/*                   'Y'  */ OSD_KEY_Y,
/*                   'Z'  */ OSD_KEY_Z,
/* VK_LWIN           0x5B */ OSD_KEY_NONE,
/* VK_RWIN           0x5C */ OSD_KEY_NONE,
/* VK_APPS           0x5D */ OSD_KEY_NONE,
/*                   0x5E */ OSD_KEY_NONE,
/*                   0x5F */ OSD_KEY_NONE,
/* VK_NUMPAD0        0x60 */ OSD_KEY_NONE,
/* VK_NUMPAD1        0x61 */ OSD_KEY_NONE,
/* VK_NUMPAD2        0x62 */ OSD_KEY_NONE,
/* VK_NUMPAD3        0x63 */ OSD_KEY_NONE,
/* VK_NUMPAD4        0x64 */ OSD_KEY_NONE,
/* VK_NUMPAD5        0x65 */ OSD_KEY_NONE,
/* VK_NUMPAD6        0x66 */ OSD_KEY_NONE,
/* VK_NUMPAD7        0x67 */ OSD_KEY_NONE,
/* VK_NUMPAD8        0x68 */ OSD_KEY_NONE,
/* VK_NUMPAD9        0x69 */ OSD_KEY_NONE,
/* VK_MULTIPLY       0x6A */ OSD_KEY_NONE,
/* VK_ADD            0x6B */ OSD_KEY_NONE,
/* VK_SEPARATOR      0x6C */ OSD_KEY_NONE,
/* VK_SUBTRACT       0x6D */ OSD_KEY_NONE,
/* VK_DECIMAL        0x6E */ OSD_KEY_NONE,
/* VK_DIVIDE         0x6F */ OSD_KEY_NONE,
/* VK_F1             0x70 */ OSD_KEY_F1,
/* VK_F2             0x71 */ OSD_KEY_F2,
/* VK_F3             0x72 */ OSD_KEY_F3,
/* VK_F4             0x73 */ OSD_KEY_F4,
/* VK_F5             0x74 */ OSD_KEY_F5,
/* VK_F6             0x75 */ OSD_KEY_F6,
/* VK_F7             0x76 */ OSD_KEY_F7,
/* VK_F8             0x77 */ OSD_KEY_F8,
/* VK_F9             0x78 */ OSD_KEY_F10, // GN: // OSD_KEY_F9,
/* VK_F10            0x79 */ OSD_KEY_F10,
/* VK_F11            0x7A */ OSD_KEY_F11,
/* VK_F12            0x7B */ OSD_KEY_F12,
/* VK_F13            0x7C */ OSD_KEY_NONE,
/* VK_F14            0x7D */ OSD_KEY_NONE,
/* VK_F15            0x7E */ OSD_KEY_NONE,
/* VK_F16            0x7F */ OSD_KEY_NONE,
/* VK_F17            0x80 */ OSD_KEY_NONE,
/* VK_F18            0x81 */ OSD_KEY_NONE,
/* VK_F19            0x82 */ OSD_KEY_NONE,
/* VK_F20            0x83 */ OSD_KEY_NONE,
/* VK_F21            0x84 */ OSD_KEY_NONE,
/* VK_F22            0x85 */ OSD_KEY_NONE,
/* VK_F23            0x86 */ OSD_KEY_CONTROL, // GN: OSD_KEY_NONE,
// /* VK_F23            0x86 */ OSD_KEY_LCONTROL, // GN: V30
/* VK_F24            0x87 */ OSD_KEY_NONE,
/*                   0x88 */ OSD_KEY_NONE,
/*                   0x89 */ OSD_KEY_NONE,
/*                   0x8A */ OSD_KEY_NONE,
/*                   0x8B */ OSD_KEY_NONE,
/*                   0x8C */ OSD_KEY_NONE,
/*                   0x8D */ OSD_KEY_NONE,
/*                   0x8E */ OSD_KEY_NONE,
/*                   0x8F */ OSD_KEY_NONE,
/* VK_NUMLOCK        0x90 */ OSD_KEY_NUMLOCK,
/* VK_SCROLL         0x91 */ OSD_KEY_SCRLOCK,
/*                   0x92 */ OSD_KEY_NONE,
/*                   0x93 */ OSD_KEY_NONE,
/*                   0x94 */ OSD_KEY_NONE,
/*                   0x95 */ OSD_KEY_NONE,
/*                   0x96 */ OSD_KEY_NONE,
/*                   0x97 */ OSD_KEY_NONE,
/*                   0x98 */ OSD_KEY_NONE,
/*                   0x99 */ OSD_KEY_NONE,
/*                   0x9A */ OSD_KEY_NONE,
/*                   0x9B */ OSD_KEY_NONE,
/*                   0x9C */ OSD_KEY_NONE,
/*                   0x9D */ OSD_KEY_NONE,
/*                   0x9E */ OSD_KEY_NONE,
/*                   0x9F */ OSD_KEY_NONE,
/*                   0xA0 */ OSD_KEY_NONE,
/*                   0xA1 */ OSD_KEY_NONE,
/*                   0xA2 */ OSD_KEY_NONE,
/*                   0xA3 */ OSD_KEY_NONE,
/*                   0xA4 */ OSD_KEY_NONE,
/*                   0xA5 */ OSD_KEY_NONE,
/*                   0xA6 */ OSD_KEY_NONE,
/*                   0xA7 */ OSD_KEY_NONE,
/*                   0xA8 */ OSD_KEY_NONE,
/*                   0xA9 */ OSD_KEY_NONE,
/*                   0xAA */ OSD_KEY_NONE,
/*                   0xAB */ OSD_KEY_NONE,
/*                   0xAC */ OSD_KEY_NONE,
/*                   0xAD */ OSD_KEY_NONE,
/*                   0xAE */ OSD_KEY_NONE,
/*                   0xAF */ OSD_KEY_NONE,
/*                   0xB0 */ OSD_KEY_NONE,
/*                   0xB1 */ OSD_KEY_NONE,
/*                   0xB2 */ OSD_KEY_NONE,
/*                   0xB3 */ OSD_KEY_NONE,
/*                   0xB4 */ OSD_KEY_NONE,
/*                   0xB5 */ OSD_KEY_NONE,
/*                   0xB6 */ OSD_KEY_NONE,
/*                   0xB7 */ OSD_KEY_NONE,
/*                   0xB8 */ OSD_KEY_NONE,
/*                   0xB9 */ OSD_KEY_NONE,
/*                   0xBA */ OSD_KEY_COLON,
/*                   0xBB */ OSD_KEY_EQUALS,
/*                   0xBC */ OSD_KEY_COMMA,
/*                   0xBD */ OSD_KEY_MINUS,
/*                   0xBE */ OSD_KEY_NONE,
/*                   0xBF */ OSD_KEY_SLASH,
/*                   0xC0 */ OSD_KEY_NONE,
/*                   0xC1 */ OSD_KEY_ALT, // OSD_KEY_CONTROL, // GN: OSD_KEY_NONE,
/*                   0xC2 */ OSD_KEY_ESC,     // GN: OSD_KEY_NONE,
/*                   0xC3 */ OSD_KEY_1, // GN: OSD_KEY_NONE,
/*                   0xC4 */ OSD_KEY_3, // GN: OSD_KEY_NONE,
/*                   0xC5 */ OSD_KEY_NONE,
/*                   0xC6 */ OSD_KEY_NONE,
/*                   0xC7 */ OSD_KEY_NONE,
/*                   0xC8 */ OSD_KEY_NONE,
/*                   0xC9 */ OSD_KEY_NONE,
/*                   0xCA */ OSD_KEY_NONE,
/*                   0xCB */ OSD_KEY_NONE,
/*                   0xCC */ OSD_KEY_NONE,
/*                   0xCD */ OSD_KEY_NONE,
/*                   0xCE */ OSD_KEY_NONE,
/*                   0xCF */ OSD_KEY_NONE,
/*                   0xD0 */ OSD_KEY_NONE,
/*                   0xD1 */ OSD_KEY_NONE,
/*                   0xD2 */ OSD_KEY_NONE,
/*                   0xD3 */ OSD_KEY_NONE,
/*                   0xD4 */ OSD_KEY_NONE,
/*                   0xD5 */ OSD_KEY_NONE,
/*                   0xD6 */ OSD_KEY_NONE,
/*                   0xD7 */ OSD_KEY_NONE,
/*                   0xD8 */ OSD_KEY_NONE,
/*                   0xD9 */ OSD_KEY_NONE,
/*                   0xDA */ OSD_KEY_NONE,
/*                   0xDB */ OSD_KEY_OPENBRACE,
/*                   0xDC */ OSD_KEY_NONE,
/*                   0xDD */ OSD_KEY_CLOSEBRACE,
/*                   0xDE */ OSD_KEY_QUOTE,
/*                   0xDF */ OSD_KEY_NONE,
/*                   0xE0 */ OSD_KEY_NONE,
/*                   0xE1 */ OSD_KEY_NONE,
/*                   0xE2 */ OSD_KEY_NONE,
/*                   0xE3 */ OSD_KEY_NONE,
/*                   0xE4 */ OSD_KEY_NONE,
/*                   0xE5 */ OSD_KEY_NONE,
/*                   0xE6 */ OSD_KEY_NONE,
/*                   0xE7 */ OSD_KEY_NONE,
/*                   0xE8 */ OSD_KEY_NONE,
/*                   0xE9 */ OSD_KEY_NONE,
/*                   0xEA */ OSD_KEY_NONE,
/*                   0xEB */ OSD_KEY_NONE,
/*                   0xEC */ OSD_KEY_NONE,
/*                   0xED */ OSD_KEY_NONE,
/*                   0xEE */ OSD_KEY_NONE,
/*                   0xEF */ OSD_KEY_NONE,
/*                   0xF0 */ OSD_KEY_NONE,
/*                   0xF1 */ OSD_KEY_NONE,
/*                   0xF2 */ OSD_KEY_NONE,
/*                   0xF3 */ OSD_KEY_NONE,
/*                   0xF4 */ OSD_KEY_NONE,
/*                   0xF5 */ OSD_KEY_NONE,
/*                   0xF6 */ OSD_KEY_NONE,
/*                   0xF7 */ OSD_KEY_NONE,
/*                   0xF8 */ OSD_KEY_NONE,
/*                   0xF9 */ OSD_KEY_NONE,
/*                   0xFA */ OSD_KEY_NONE,
/*                   0xFB */ OSD_KEY_NONE,
/*                   0xFC */ OSD_KEY_NONE,
/*                   0xFD */ OSD_KEY_NONE,
/*                   0xFE */ OSD_KEY_NONE,
/*                   0xFF */ OSD_KEY_NONE,
};

byte key[OSD_NUMKEYS];


/* stupid stub functions to prevent changing common.c */
DIR * opendir(const char *basename)
{
   return (DIR *)1;
}


struct dirent * readdir(DIR *dirp)
{
   return NULL;
}


void closedir(DIR *dirp)
{

}


LARGE_INTEGER uclocks_per_sec;

DWORDLONG osd_win32_uclock()
{
   LARGE_INTEGER t;

   if (uclocks_per_sec.QuadPart == 1000)
      return (DWORDLONG)timeGetTime();
   QueryPerformanceCounter(&t);
   return (DWORDLONG)t.QuadPart;
}


DWORDLONG osd_win32_uclocks_per_sec()
{
   return (DWORDLONG)uclocks_per_sec.QuadPart;
}


/* put here anything you need to do when the program is started. Return 0 if */
/* initialization was successful, nonzero otherwise. */
int osd_init(int argc,char **argv) 
{ 
	int mykey = 0;
	
	m_hAppWnd = MAME32_CreateWindow();
	if (!IsWindow(m_hAppWnd))
	{
		return 1;
	}
	
	//    ShowWindow(g_hMain, SW_HIDE); // hide the UI
	
    ShowWindow(m_hAppWnd, SW_SHOW);
    SetForegroundWindow(m_hAppWnd);
	
#ifdef GAMEX
	if (m_firsttime)
	{
		m_firsttime = FALSE;
		
		if ( !GAMEX_Init( m_hAppWnd ) )
		{
			if (IsWindow(m_hAppWnd))
			{
				DestroyWindow(m_hAppWnd);
			}
			
			return 1;
		}
	}
	else
	{
		GAMEX_Resume();
		{
			;
		}
	}
	
	//	m_pusLine = (unsigned short *)GAMEX_BeginDraw(); // GAMEXTEST
#endif
	
	if (!QueryPerformanceFrequency(&uclocks_per_sec))
		uclocks_per_sec.QuadPart = 1000;
	
	CESound_init();
	sound_start(); // start sound systems					
	
	
	// Keep the ESC key from sticking during subsequent
	// emulation runs within the same Mame session
	for (mykey = 0; mykey < OSD_NUMKEYS; mykey++)
	{
		key[mykey] = 0;
	}
	
	return 0;
}


/* put here cleanup routines to be executed when the program is terminated. */
void osd_exit(void)
{
	BOOL res;
#ifdef GAMEX
	//	GAMEX_EndDraw(); // GAMEXTEST
		
		GAMEX_Suspend();	
#endif
	
#if USED // GN
	if (!is_window)
		ShowCursor(TRUE);
#endif
	
	if (IsWindow(m_hAppWnd))
	{
		res = DestroyWindow(m_hAppWnd);
	}
	
    // GN: stop sound sub-system
	sound_stop(); 
	CESound_exit();
}


// from Mame30, msdos.c
/* set the bitmap to black */
void osd_clearbitmap(struct osd_bitmap *bitmap)
{
	int i;


	for (i = 0;i < bitmap->height;i++)
		memset(bitmap->line[i],0,bitmap->width);
}


/* Create a bitmap. Also calls osd_clearbitmap() to appropriately initialize */
/* it to the background color. */
struct osd_bitmap *osd_create_bitmap(int width,int height)
{
	struct osd_bitmap *bitmap;

#if USED // GN: V30
	if (Machine->orientation & ORIENTATION_SWAP_XY)
	{
		int temp;

		temp = width;
		width = height;
		height = temp;
	}
#endif

	// GN: allocation was too small and causing Windows to trash us when freeing the bitmap
    // if ((bitmap = malloc(sizeof(struct osd_bitmap) + (height-1)*sizeof(unsigned char *))) != 0)
    if ((bitmap = malloc(sizeof(struct osd_bitmap) + (height-0)*sizeof(unsigned char *))) != 0)
	// if ((bitmap = malloc(sizeof(struct osd_bitmap))) != 0) // V30
	{
		int i;
		unsigned char *bm;


		bitmap->width = width;
		bitmap->height = height;
		if ((bm = malloc(width * height * sizeof(unsigned char))) == 0)
		{
			free(bitmap);
			return 0;
		}

#if USED // GN: V30
		if ((bitmap->line = malloc(height * sizeof(unsigned char *))) == 0)
		{
			free(bm);
			free(bitmap);
			return 0;
		}
#endif

		for (i = 0;i < height;i++)
			bitmap->line[i] = &bm[i * width];

		bitmap->_private = bm;

		osd_clearbitmap(bitmap);
	}

	return bitmap;
}


// for Mame30
void osd_mark_dirty(int x1, int y1, int x2, int y2, int ui)
{
}


void osd_free_bitmap(struct osd_bitmap *bitmap)
{
   if (bitmap)
   {
      free(bitmap->_private);
      free(bitmap);
   }
}


/* Create a display screen, or window, large enough to accomodate a bitmap */
/* of the given dimensions. I don't do any test here (224x288 will just do */
/* for now) but one could e.g. open a window of the exact dimensions */
/* provided. Return a osd_bitmap pointer or 0 in case of error. */

/* GN: V30
struct osd_bitmap *osd_create_display(int width,int height,int totalcolors,
			const unsigned char *palette,unsigned char *pens,int attributes)
*/
struct osd_bitmap *osd_create_display(int width,int height)
{
	RECT wr;

#ifdef GAMEX
	m_bpp = GAMEX_GetFBBpp();
	GAMEX_GetScreenRect(&m_screenrect);
	m_pitchY = GAMEX_GetFByPitch();
	m_pitchX = GAMEX_GetFBxPitch();


	m_pMAMEBitmap = osd_create_bitmap(width, height);

	ClearScreen();
#else
	int				i;
   	HDC				hDC;
	BYTE*			bm = 0;


    hDC = GetDC(NULL); // DC for DibSection
	m_hMemDC = CreateCompatibleDC(hDC);

    m_pInfo = (BITMAPINFO*)malloc(sizeof(BITMAPINFOHEADER) +
                                       sizeof(RGBQUAD) * OSD_NUMPENS);

    m_pInfo->bmiHeader.biSize          = sizeof(BITMAPINFOHEADER); 
    m_pInfo->bmiHeader.biWidth         = width;
    m_pInfo->bmiHeader.biHeight        = (-1) * height; /* Negative means "top down" */
    m_pInfo->bmiHeader.biPlanes        = 1;
    m_pInfo->bmiHeader.biBitCount      = 8; // This.m_nDepth;
    m_pInfo->bmiHeader.biCompression   = BI_RGB;
    m_pInfo->bmiHeader.biSizeImage     = 0;
    m_pInfo->bmiHeader.biXPelsPerMeter = 0;
    m_pInfo->bmiHeader.biYPelsPerMeter = 0;
    m_pInfo->bmiHeader.biClrUsed       = 0;
    m_pInfo->bmiHeader.biClrImportant  = 0;


	m_pMAMEBitmap = malloc( sizeof(struct osd_bitmap) + (height-0)*sizeof(unsigned char *) );
//	m_pMAMEBitmap = malloc(sizeof(struct osd_bitmap)); // GN: Mame30


	m_pMAMEBitmap->width  = width;
	m_pMAMEBitmap->height = height;


	// GN: create the DIB and setup up a BM handle for Windows
	m_hBitmap = CreateDIBSection(hDC, m_pInfo, DIB_RGB_COLORS , &bm, NULL, 0); // GNPTEST


	ReleaseDC(NULL, hDC); 
	m_hOldBitmap = SelectObject(m_hMemDC, (HGDIOBJ)m_hBitmap);


	// GN: now do the CreateBitmap stuff for the Mame Core
	m_pMAMEBitmap->_private = bm;


	// GN: need this for Mame30
/*
	m_pMAMEBitmap->line = malloc(height * sizeof(unsigned char *));
*/


	for (i = 0;i < height;i++)
		m_pMAMEBitmap->line[i] = &bm[i * width];
#endif

#ifndef GAMEX
	// for desktop testing, set game window to size of PPC screen
    SetWindowPos(m_hAppWnd,
                 HWND_NOTOPMOST,
                 0, 0,
                 240,
                 320,
                 SWP_NOMOVE);

	// having set the game window to some (arbitrary) size, 
	// get the actual client rect so that we can adjust the window for the 
	// title bar and border (there's probably some better way!)
	GetClientRect(m_hAppWnd, &wr);

    SetWindowPos(m_hAppWnd,
                 HWND_NOTOPMOST,
                 0, 0,
                 240 + (240 - wr.right),
                 320 + (320 - wr.bottom), // add the offset for title bar
                 SWP_NOMOVE);

	GetClientRect(m_hAppWnd, &wr);
#else
	// for the handheld, use the actual (maximized) window since we write full screen
	GetWindowRect(m_hAppWnd, &wr);
	wr.top = 0; // kludge, damn title bar screws this up!
#endif

	// do the calcs for screen centering and clipping

	m_VisibleRect.m_Left = (wr.right > width) ? 0 : (width - wr.right) / 2;
	m_VisibleRect.m_Left += 0x3; // round up
	m_VisibleRect.m_Left &= 0xfffffffc; // qw align

	m_VisibleRect.m_Right  = (wr.right > width) ? width : m_VisibleRect.m_Left + wr.right;
	m_VisibleRect.m_Right &= 0xfffffffc; // round down, qw align

	m_VisibleRect.m_Top = (wr.bottom > height) ? 0 : (height - wr.bottom) / 2;
	m_VisibleRect.m_Top  += 0x3; // round up
	m_VisibleRect.m_Top  &= 0xfffffffc; // qw align

	m_VisibleRect.m_Bottom = (wr.bottom > height) ? height : m_VisibleRect.m_Top + wr.bottom;
	m_VisibleRect.m_Bottom &= 0xfffffffc; // round down, qw align

	m_VisibleRect.m_Width  = m_VisibleRect.m_Right  - m_VisibleRect.m_Left;
	m_VisibleRect.m_Height = m_VisibleRect.m_Bottom - m_VisibleRect.m_Top;

	
	m_DisplayRect.m_Left = (wr.right - m_VisibleRect.m_Width) / 2;
	m_DisplayRect.m_Left &= 0xfffffffc; // round down, qw align
    m_DisplayRect.m_Right = m_DisplayRect.m_Left + m_VisibleRect.m_Width;

	m_DisplayRect.m_Top = (wr.bottom - m_VisibleRect.m_Height) / 2;
	m_DisplayRect.m_Top &= 0xfffffffc; // round down, qw align
    m_DisplayRect.m_Bottom = m_DisplayRect.m_Top + m_VisibleRect.m_Height;


	// For Mame30, we get to work the pens ourselves!
/*
	for (i = 0;i < totalcolors;i++)
		pens[i] = osd_obtain_pen(palette[3*i],palette[3*i+1],palette[3*i+2]);
*/
    return m_pMAMEBitmap;
}



/*
 * code helpful for making cheats =)
 */

/*
BOOL mem_scanning = FALSE;
BYTE mem_scan_value = 0;
char *memory_mask;

void MemScanInit()
{
   memory_mask = (char *)malloc(65536);
   memset(memory_mask,1,65536);
}

void MemScanPareList()
{
   int i,possible;

   if (!memory_mask)
      MemScanInit();

   for (i=0;i<65536;i++)
      if (RAM[i] != mem_scan_value)
	 memory_mask[i] = 0;

   possible = 0;
   for (i=0;i<65536;i++)
      if (memory_mask[i])
	 possible++;

   dprintf("paring list with %i; %i still possible matches\n",mem_scan_value,possible);
   if (possible < 10)
   {
      for (i=0;i<65536;i++)
	 if (memory_mask[i])
	    dprintf("LOCATION %04X may be it\n",i);
   }
}

void MemScanAddKey(int vk)
{
   if (vk == VK_RETURN)
   {
      MemScanPareList();
      mem_scanning = FALSE;
      return;
   }

   if (vk == VK_F6)
   {
      dprintf("dumping list\n");
      return;
   }

   if (vk >= '0' && vk <= '9')
      mem_scan_value = 10*mem_scan_value + vk - '0';

   
}
*/


/* shut up the display */
void osd_close_display(void)
{
#ifdef GAMEX
   osd_free_bitmap(m_pMAMEBitmap);
#else
	// cleanup the DIB and display bitmap
	SelectObject(m_hMemDC, (HGDIOBJ)m_hOldBitmap);
	DeleteObject(m_hBitmap);
	free(m_pMAMEBitmap);
	free(m_pInfo);
#endif

}


int osd_obtain_pen(unsigned char red, unsigned char green, unsigned char blue)
{
	int retval;

#ifdef GAMEX
	// setup a palette for 16-bit, 565 format
	WORD PixelCol = (unsigned short) 
		( 
		(red   & 0xf8) << 8 | 
		(green & 0xfc) << 3 | 
		(blue        ) >> 3
		);

	m_palette2[m_pencount] = PixelCol;
#else
	// set RGBs directly into DIB color table
	RGBQUAD dibentry;
	dibentry.rgbRed = red;
	dibentry.rgbBlue = blue;
	dibentry.rgbGreen = green;
	SetDIBColorTable(m_hMemDC,m_pencount, 1, &dibentry);
#endif
	
	m_pencount++;
	
	/* dprintf("OOP %u %u %u : %i\n",red,green,blue,
	palette_offset+pal.palNumEntries); */
	retval = ( /* palette_offset+ */ m_first_free_pen) % 256;
	m_first_free_pen = (m_first_free_pen + 1)%256;
	
    return retval;
}


void osd_win32_set_color(int offset,int data) /* palette animation ! */
{
#if USED // GN: need this for tutankhm   
   if (is_window)
      return; // doesn't work right in a window
   //dprintf("offset %i\n",offset);

   pal.entries[offset].peRed = ((data & 0x07)<<5);
   if (pal.entries[offset].peRed != 0)
      pal.entries[offset].peRed += 7;
   
   pal.entries[offset].peGreen = (((data>>3) & 0x07)<<5);
   if (pal.entries[offset].peGreen != 0)
      pal.entries[offset].peGreen += 7;
   
   pal.entries[offset].peBlue = (((data>>6) & 0x03)<<6);
   if (pal.entries[offset].peBlue != 0)
      pal.entries[offset].peBlue += 3;

   DirectDrawSetColor(offset,&pal.entries[offset]);
#endif
}


/* Update the display. */
void osd_update_display()
{
// Begin GN
#ifdef GAMEX
	DrawScreen();
#else
//    InvalidateRect(MAME32App.m_hWnd, &This.m_ClientRect, FALSE);
    InvalidateRect( m_hAppWnd, NULL, FALSE);

//    UpdateWindow(MAME32App.m_hWnd);
    UpdateWindow(m_hAppWnd);

//	MAME32_ProcessMessages();
#endif
	return;
// End GN
}


int osd_start_audio_stream(int stereo)
{
	// GN: from Mame36.
	// Not an interface used with Mame27, but glue code for use by mixer.c
    return CESound_start_audio_stream(stereo);
}


void osd_stop_audio_stream(void)
{
	// GN: from Mame36.
	// Not an interface used with Mame27, but glue code for use by mixer.c

	//  MAME32App.m_pSound->stop_audio_stream();
	CESound_stop_audio_stream(); // currently unimplemented, just here for completeness.
}


int osd_update_audio_stream(INT16* buffer)
{
	// GN: from Mame36.
	// Not an interface used with Mame27, but glue code for use by mixer.c
    return CESound_update_audio_stream(buffer);
}


void osd_update_audio(void)
{
   if (play_sound == 0) 
      return;

	/* update sound */ // GN: interface from Mame36 sound engine
	sound_update();
}


void osd_play_sample(int channel,unsigned char *data,int len,int freq,int volume,int loop)
// void osd_play_sample(int channel,signed char *data,int len,int freq,int volume,int loop) // Mame30
{
   if (play_sound == 0 || channel >= NUMVOICES) return;

	// GN: the machine interface calls this (because of custom_io_write)
	// In Mame36, the machine interface calls directly to sample_start()
	// void sample_start(int channel,int samplenum,int loop)
	sample_start2(channel, data, len, freq, volume, loop);
	sample_set_volume(channel, volume);
}


void osd_play_streamed_sample(int channel,unsigned char *data,int len,int freq,int volume)
// void osd_play_streamed_sample(int channel,signed char *data,int len,int freq,int volume) // Mame30
{
	// GN: used for streams such as PSG
	sample_start2(channel, data, len, freq, volume, 0);
}


void osd_adjust_sample(int channel,int freq,int volume)
{
   if (play_sound == 0 || channel >= NUMVOICES) 
      return;

	// GN: from sndhrdw/pengo.c:pengo_sound_enable_w()
	sample_set_freq(channel, freq);
	sample_set_volume(channel, volume);
}


void osd_stop_sample(int channel)
{
   if (play_sound == 0 || channel >= NUMVOICES) 
      return;

	// used for looped samples.
	sample_stop(channel);
}


void osd_restart_sample(int channel)
{
   if (play_sound == 0 || channel >= NUMVOICES) 
      return;
}


int osd_get_sample_status(int channel)
{
   int stopped = 0;

   if (play_sound == 0 || channel >= NUMVOICES) 
      return -1;

   return stopped;
}


void osd_ym2203_write(int n, int r, int v)
{

}


void osd_ym2203_update(void)
{

}


void osd_set_mastervolume(int volume)
{

}


/* check if a key is pressed. The keycode is the standard PC keyboard code, as */
/* defined in osdepend.h. Return 0 if the key is not pressed, nonzero otherwise. */
int osd_key_pressed(int keycode)
{
   MSG msg;

   /* dprintf("Checking for key %i\n",keycode); */

//   while (PeekMessage(&msg,hMain,0,0,PM_REMOVE))
   while (PeekMessage(&msg,NULL,0,0,PM_REMOVE)) // GN
   {
      /* dprintf("OKP Handling message %i\n",msg.message); */
   
      TranslateMessage(&msg);
      DispatchMessage(&msg);

   }
#if USED
   if (keycode == OSD_KEY_ESC && ending == TRUE )
   {
      return 1;
   }
#endif

   // Key F11....used as an option from the UI
   // (it's sort of a hack, keeps us from changing mame.c)
	if ( keycode == 87 && g_ShowFPS )
	{
		return 1;
	}

   /* dprintf("returning %i\n",key[keycode]); */
   return key[keycode];
}


/*
 * Wait until a key is pressed and return its code.
 */
int osd_read_key(void)
{
	MSG msg;
	int osd_key;
	
	static int first_time = TRUE;
	
	//   while (GetMessage(&msg,hMain,0,0))
	while (GetMessage(&msg,NULL,0,0)) // GN
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
		/*
		if (ending) 
		break;
		*/
		if (msg.message == WM_KEYDOWN || 
			(msg.message == WM_SYSKEYDOWN && msg.wParam == VK_MENU))
		{
			osd_key = Win32KeyToOSDKey(msg.wParam);
			if (osd_key == 0)
				return OSD_KEY_1; /* in usrintrf.c, it crashes if we return 0 sometimes */
			else
				return osd_key;
		}
	}
	
	osd_exit();
#ifndef _WIN32_WCE // GN
	ExitProcess(1);
#endif
	return 1;
}

int Win32KeyToOSDKey(UINT vk)
{
   if (vk <= 255)
   {
      return key_code_table[vk];
   }

   return OSD_KEY_NONE;
}


/* Wait for a key press and return keycode.  Support repeat */
int osd_read_keyrepeat(void)
{
   int i;

   for (i=0;i<OSD_NUMKEYS;i++) 
      key[i]=FALSE;

   return osd_read_key();
}


/* return the name of a key */
const char *osd_key_name(int keycode)
{
   static char *keynames[] = 
   { 
      "ESC", "1", "2", "3", "4", "5", "6", "7", "8", "9", "0",
      "MINUS", "EQUAL", "BACKSPACE", "TAB", "Q", "W", "E", "R", "T", "Y",
      "U", "I", "O", "P", "OPENBRACE", "CLOSEBRACE", "ENTER", "CONTROL",
      "A", "S", "D", "F", "G", "H", "J", "K", "L", "COLON", "QUOTE",
      "TILDE", "LEFTSHIFT", "NULL", "Z", "X", "C", "V", "B", "N", "M", "COMMA",
      "STOP", "SLASH", "RIGHTSHIFT", "ASTERISK", "ALT", "SPACE", "CAPSLOCK",
      "F1", "F2", "F3", "F4", "F5", "F6", "F7", "F8", "F9", "F10", "NUMLOCK",
      "SCRLOCK", "HOME", "UP", "PGUP", "MINUS PAD", "LEFT", "5 PAD", "RIGHT",
      "PLUS PAD", "END", "DOWN", "PGDN", "INS", "DEL", "F11", "F12" 
   };
   
   if (keycode && keycode <= OSD_MAX_KEY) 
      return (char *)keynames[keycode-1];
   
   return 0;
}


// Mame30 joystick compatibility
int osd_analogjoy_read(int axis)
{
	return 0;
}


/* return the name of a joystick button */
const char *osd_joy_name(int joycode)
{
	return 0;
}


int joy_left, joy_right, joy_up, joy_down;
int joy_b1, joy_b2;
int joy_b3, joy_b4;

void osd_poll_joystick(void)
{

}


/* check if the joystick is moved in the specified direction, defined in */
/* osdepend.h. Return 0 if it is not pressed, nonzero otherwise. */
int osd_joy_pressed(int joycode)
{
   return 0;
}

#if USED // GN
void dprintf(char *fmt,...)
{
   char s[500];
   DWORD written;
   va_list marker;

   if (!win32_debug)
      return;

   va_start(marker,fmt);

   vsprintf(s,fmt,marker);

#if 0 // GN // #if 1
   WriteFile(GetStdHandle(STD_OUTPUT_HANDLE),s,strlen(s),&written,NULL);
//#else
   {
      static FILE *junk;
      if (junk == NULL)
	 junk = fopen("debug.txt","wt");
      if (junk != NULL)
	 fprintf(junk, s);
   }
#endif
   va_end(marker);
}
#endif


int osd_trak_read(int axis) 
{
   if(!use_trak) 
   {
      return(NO_TRAK);
  }

   return 0;
}

void osd_trak_center_x(void) {
  large_trak_x = 0;
}

void osd_trak_center_y(void) {
  large_trak_y = 0;
}

#define MAXPIXELS 100000
char * pixel[MAXPIXELS];
int p_index=-1;

__inline void draw_pixel (int x, int y, int col)
{
   char *address;

   if (x<0 || x >= bitmap->width)
      return;
   if (y<0 || y >= bitmap->height)
      return;

   address=&(bitmap->line[y][x]);
   *address=(char)col;
   p_index++;
   pixel[p_index]=address;
}

void open_page (int *x_res, int *y_res, int step)
{
	int i;
	unsigned char bg;

	*x_res=bitmap->width;
	*y_res=bitmap->height;
	bg=Machine->pens[0];
	for (i=p_index; i>=0; i--)
	{
		*(pixel[i])=bg;
	}
	p_index=-1;
}

void close_page (void)
{
}

void draw_to (int x2, int y2, int col)
{
	static int x1=0;
	static int y1=0;

	int temp_x, temp_y;
	int dx,dy,cx,cy,sx,sy;
	
#if 0
	if (x1<0 || y1<0 || x2<0 || y2<0 ||
		x1>=bitmap->width || y1>=bitmap->height ||
		x2>=bitmap->width || y2>=bitmap->height)
	{
		if (errorlog)
			fprintf(errorlog,
			"line:%d,%d nach %d,%d color %d\n",
			 x1,y1,x2,y2,col);
		return;
	}
#endif

	if (col<0)
	{
		x1=x2;
		y1=y2;
		return;
	} else 
		col=Machine->gfx[0]->colortable[col];

	temp_x = x2; temp_y = y2;
	
	dx=abs(x1-x2);
	dy=abs(y1-y2);

	if ((dx>=dy && x1>x2) || (dy>dx && y1>y2))
	{
		int t;
		t = x1; x1 = x2; x2 = t;
		t = y1; y1 = y2; y2 = t;
	}
	sx = ((x1 <= x2) ? 1 : -1);
	sy = ((y1 <= y2) ? 1 : -1);
	cx=dx/2;
	cy=dy/2;

	if (dx == dy)
	{
		while (x1 <= x2)
		{
			draw_pixel(x1,y1,col);
			x1+=sx;
			y1+=sy;
		}
	}
	else if (dx>dy)
	{
		while (x1 <= x2)
		{
			draw_pixel(x1,y1,col);
			x1+=sx;
			cx-=dy;
			if (cx < 0)
			{
				y1+=sy;
				cx+=dx;
			}
		}
	}
	else
	{
		while (y1 <= y2)
		{
			draw_pixel(x1,y1,col);
			y1+=sy;
			cy-=dx;
			if (cy < 0)
			{
				x1+=sx;
				cy+=dy;
			}
		}
	}	
	x1 = temp_x;
	y1 = temp_y;
}


#ifdef GAMEX
// The GAPI screen refresh function.
void DrawScreen(void)
{    
	//	unsigned short *pusLine = m_pusLine; // if we could just do this once

	unsigned short *palette = m_palette2;

	int scrheight = m_screenrect.bottom;    // 320
	int bpp       = m_bpp;                  // 16
	int pitchX    = m_pitchX / (m_bpp / 8); // 640 / 2
	int pitchY    = m_pitchY >> 1;          // -2 >> 1

	int srcwidth            = m_VisibleRect.m_Width; // m_pMAMEBitmap->width;
	int srcheight           = m_VisibleRect.m_Height; // m_pMAMEBitmap->height;
	int destoffsx           = m_DisplayRect.m_Left * pitchX;
	int destoffsy           = m_DisplayRect.m_Top * pitchY;
	
	unsigned char **srcrow    = m_pMAMEBitmap->line + m_VisibleRect.m_Top;
	unsigned char **srcrowmax = srcrow + srcheight;

	unsigned short *pusLine   = (unsigned short *)GAMEX_BeginDraw();
	pusLine   += destoffsy;

	if (pusLine == NULL)
	{
		return; // NOT OK TO DRAW
	}
	
	for ( ; srcrow < srcrowmax; pusLine += pitchY ) 
	{
		unsigned char  * srcline    = *srcrow + m_VisibleRect.m_Left;
		unsigned char  * srclinemax = srcline + srcwidth;
	    unsigned short * pusRow     = pusLine + destoffsx;
		srcrow++;
		
		for ( ; srcline < srclinemax; pusRow += pitchX)
		{
			*pusRow = *(palette + *srcline++);
		}
	}
	
	GAMEX_EndDraw();
}


// Fill FB with 0's.
void ClearScreen(void)
{    
	// 16 bit per pixel code.  Note 2 different pixel formats.
//	switch (m_bpp)
	{
//	case 16: 
		{
			unsigned short * pusLine = (unsigned short *)GAMEX_BeginDraw();

			unsigned short * line;
			unsigned short * maxline;
			unsigned short * offs = 0;


			pusLine -= 320; // FB start given as upper left with negative
			                // going pitch...so adjust start address to 
			                // actual physical FB start and use positive 
			                // going address.

			maxline = 240 * 320 + pusLine;


			if (pusLine == NULL)
			{
				return; // FALSE; // NOT OK TO DRAW
			}

			for ( line = pusLine; line < maxline; line+=320)
			{
				unsigned short *offsmax = line + 320;
				for (offs = line; offs < offsmax; offs++)
				{
					*offs = 0;
				}
			}

			GAMEX_EndDraw();
//			break;
		}
	}
}
#endif


//////////////////////////////////////////////////////////
#ifndef GAMEX
void osd_win32_OnPaint(HWND hWnd)
{
    PAINTSTRUCT     ps;

    BeginPaint(hWnd, &ps);

//    if (This.m_nDepth == 8)
    {
        /* 8 bit uses windows palette. */
//        HPALETTE hOldPalette;

//        hOldPalette = SelectPalette(ps.hdc, m_hPalette, FALSE);
//        retval = RealizePalette(ps.hdc);

	    BitBlt(ps.hdc,
    		m_DisplayRect.m_Left,  // x-coord of destination upper-left corner
    		m_DisplayRect.m_Top, // y-coord of destination upper-left corner
    		m_pInfo->bmiHeader.biWidth,         //  width of destination rectangle
     		(-1) * m_pInfo->bmiHeader.biHeight, // height of destination rectangle
    		m_hMemDC,
    		m_VisibleRect.m_Left, // must remember that bitmap width and height are
    		m_VisibleRect.m_Top,  // often given from the driver as some larger size
    		SRCCOPY);			  // than the driver visible area, such as 256x256

//    if (hOldPalette != NULL)
//           SelectPalette(ps.hdc, hOldPalette, FALSE);        
    }

    EndPaint(hWnd, &ps); 
}
#endif



// File handling functions used in Mame30 and beyond
#define FTEST 1
//#if USED // GN: V30
//////////////////////////////////////////////////////////
int osd_fseek(void *file,int offset,int whence)
{
#ifdef FTEST // GN
	return File.fseek(file, offset, whence);
#else
	return fseek((FILE *)file,offset,whence);
#endif
}

int osd_fread(void *file,void *buffer,int length)
{
#ifdef FTEST // GN
	return File.fread(file, buffer, length);
#else
	return fread(buffer,1,length,(FILE *)file);
#endif
}

//////////////////////////////////////////////////////////
int osd_fwrite(void *file,const void *buffer,int length)
{
#ifdef FTEST // GN
	return File.fwrite(file, buffer, length);
#else
	return fwrite(buffer,1,length,(FILE *)file);
#endif
}


//////////////////////////////////////////////////////////
/* from Mame30, msdos.c
/* gamename holds the driver name, filename is only used for ROMs and samples. */
/* if 'write' is not 0, the file is opened for write. Otherwise it is opened */
/* for read. */
void *osd_fopen(const char *gamename,const char *filename,int filetype,int write)
{
#ifdef FTEST // GN
	return File.fopen(gamename, filename, filetype, write);
#else
	char name[100];
	void *f;
	char *dirname;

	set_config_file ("mame.cfg");

	switch (filetype)
	{
		case OSD_FILETYPE_ROM:
		case OSD_FILETYPE_SAMPLE:
			sprintf(name,"%s/%s",gamename,filename);
			f = fopen(name,write ? "wb" : "rb");
			if (f == 0)
			{
				/* try with a .zip directory (if ZipMagic is installed) */
				sprintf(name,"%s.zip/%s",gamename,filename);
				f = fopen(name,write ? "wb" : "rb");
			}
			if (f == 0)
			{
				/* try with a .zif directory (if ZipFolders is installed) */
				sprintf(name,"%s.zif/%s",gamename,filename);
				f = fopen(name,write ? "wb" : "rb");
			}
			if (f == 0)
			{

				/* try again in the appropriate subdirectory */
				dirname = "";
				if (filetype == OSD_FILETYPE_ROM)
					dirname = get_config_string("directory","roms","ROMS");
				if (filetype == OSD_FILETYPE_SAMPLE)
					dirname = get_config_string("directory","samples","SAMPLES");

				sprintf(name,"%s/%s/%s",dirname,gamename,filename);
				f = fopen(name,write ? "wb" : "rb");
				if (f == 0)
				{
					/* try with a .zip directory (if ZipMagic is installed) */
					sprintf(name,"%s/%s.zip/%s",dirname,gamename,filename);
					f = fopen(name,write ? "wb" : "rb");
				}
				if (f == 0)
				{
					/* try with a .zif directory (if ZipFolders is installed) */
					sprintf(name,"%s/%s.zif/%s",dirname,gamename,filename);
					f = fopen(name,write ? "wb" : "rb");
				}
			}
			return f;
			break;
		case OSD_FILETYPE_HIGHSCORE:
			/* try again in the appropriate subdirectory */
			dirname = get_config_string("directory","hi","HI");

			sprintf(name,"%s/%s.hi",dirname,gamename);
			f = fopen(name,write ? "wb" : "rb");
			if (f == 0)
			{
				/* try with a .zip directory (if ZipMagic is installed) */
				sprintf(name,"%s.zip/%s.hi",dirname,gamename);
				f = fopen(name,write ? "wb" : "rb");
			}
			if (f == 0)
			{
				/* try with a .zif directory (if ZipFolders is installed) */
				sprintf(name,"%s.zif/%s.hi",dirname,gamename);
				f = fopen(name,write ? "wb" : "rb");
			}
			return f;
			break;
		case OSD_FILETYPE_CONFIG:
			/* try again in the appropriate subdirectory */
			dirname = get_config_string("directory","cfg","CFG");

			sprintf(name,"%s/%s.cfg",dirname,gamename);
			f = fopen(name,write ? "wb" : "rb");
			if (f == 0)
			{
				/* try with a .zip directory (if ZipMagic is installed) */
				sprintf(name,"%s.zip/%s.cfg",dirname,gamename);
				f = fopen(name,write ? "wb" : "rb");
			}
			if (f == 0)
			{
				/* try with a .zif directory (if ZipFolders is installed) */
				sprintf(name,"%s.zif/%s.cfg",dirname,gamename);
				f = fopen(name,write ? "wb" : "rb");
			}
			return f;
			break;
		case OSD_FILETYPE_INPUTLOG:
			sprintf(name,"%s.inp",filename);
			return fopen(name,write ? "wb" : "rb");
			break;
		default:
			return 0;
			break;
	}
#endif
}


//////////////////////////////////////////////////////////
void osd_fclose(void *file)
{
#ifdef FTEST // GN
	File.fclose(file);
#else
	fclose((FILE *)file);
#endif
}
//#endif // GN: V30



// Need one of these for Mame28
//////////////////////////////////////////////////////////
void osd_get_pen(int pen, unsigned char* pRed, unsigned char* pGreen, unsigned char* pBlue)
{

}


// Tired of changing this, so I will just copy it (from Mame27)
//int main(int argc,char **argv) // GN
#define DEFAULT_NAME "pacman"
int run_game(int argc,char **argv)
{
	int i,list = 0,help,log,success;  /* MAURY_BEGIN: varie */

	for (i = 1;i < argc;i++) if (argv[i][0] == '/') argv[i][0] = '-';  /* covert '/' in '-' */

	help = (argc == 1);
	for (i = 1;i < argc;i++)       /* help me, please! */
	{
		if ((stricmp(argv[i],"-?") == 0) || (stricmp(argv[i],"-h") == 0) || (stricmp(argv[i],"-help") == 0))
			help = 1;
	}

	success = 1;

	log = 0;
	for (i = 1;i < argc;i++)
	{
		if (stricmp(argv[i],"-log") == 0)
			log = 1;
	}

	if (log) errorlog = fopen("error.log","wa");

	if (init_machine(argc > 1 && argv[1][0] != '-' ? argv[1] : DEFAULT_NAME,argc,argv) == 0)
	{
		if (osd_init(argc,argv) == 0)
		{
			if (run_machine(argc > 1 && argv[1][0] != '-' ? argv[1] : DEFAULT_NAME) == 0)
				success = 0;
			else printf("Unable to start emulation\n");

			osd_exit();
		}
		else printf("Unable to initialize system\n");

		shutdown_machine();
	}
	else printf("Unable to initialize machine emulation\n");

	if (errorlog) fclose(errorlog);

	return success;
}


/////// from Mame30, msdos.c
void osd_led_w(int led,int on) 
{
}

// Mame30
int osd_get_config_frameskip (int def_frameskip)
{
	set_config_file ("mame.cfg");
	return get_config_int("config","frameskip",def_frameskip);
}

// Mame30
int osd_get_config_samplebits (int def_samplebits)
{
	set_config_file ("mame.cfg");
	return get_config_int("config","samplebits",def_samplebits);
}

// Mame30
int osd_get_config_samplerate (int def_samplerate)
{
	set_config_file ("mame.cfg");
	return get_config_int("config","samplerate",def_samplerate);
}

// Mame30
void osd_set_config (int def_samplerate, int def_samplebits)
{
}

// Mame30
void osd_save_config (int frameskip, int samplerate, int samplebits)
{
}

// Mame30
char *get_config_string(char *type, char *token, char *def_value)
{
	return def_value;
}

// Mame30
void set_config_file (char *file)
{
}

// Mame30
int get_config_int(char *type, char *token, int def_value)
{
	return def_value;
}
