/***************************************************************************

    M.A.M.E.CE3  -  Multiple Arcade Machine Emulator for Pocket PC
    Win32 Portions Copyright (C) 1997-98 Michael Soderstrom and Chris Kirmse
    
    This file is part of MAMECE3, and may only be used, modified and
    distributed under the terms of the MAME license, in "MAME.txt".
    By continuing to use, modify or distribute this file you indicate
    that you have read the license and understand and accept it fully.

 ***************************************************************************/


#ifndef __FILE_H__
#define __FILE_H__

#define FILENAME_MAX    260
#define OSD_FILETYPE_FLYER      1001

static char szRootPath[MAX_PATH];

//#ifdef __cplusplus
//extern "C" {
//#endif

int			File_faccess(const char *filename, int filetype);
void*		File_fopen(const char *gamename,const char *filename,int filetype,int write);
int			File_fread(void *file,void *buffer,int length);
int			File_fwrite(void *file,const void *buffer,int length);
int			File_fseek(void *file,int offset,int whence);
void		File_fclose(void *file);
int			File_fchecksum(const char *gamename, const char *filename, unsigned int *length, unsigned int *sum);
int			File_ftell(void *file);
int			File_fsize(void *file);
unsigned int File_fcrc(void *file);
int			File_fread_scatter(void *file,void *buffer,int length,int increment);


//#ifdef __cplusplus
//}
//#endif

typedef struct
{
    int index; /* into file_list, to keep track of left open files */
    int access_type;
    unsigned int crc;
    
    /* ACCESS_FILE */
    FILE *fptr;
    
    /* ACCESS_ZIP */
    char *file_data;
    int file_length;
    int file_offset;
    
} mame_file;

enum
{
    ACCESS_FILE = 1,
    ACCESS_ZIP  = 2,
    ACCESS_RAMFILE,
};

extern int load_zipped_file (const char *zipfile, const char *filename,unsigned char **buf, unsigned int *length);

#endif
