/***************************************************************************

    M.A.M.E.32  -  Multiple Arcade Machine Emulator for WinCE
    Win32 Portions Copyright (C) 1997-98 Michael Soderstrom and Chris Kirmse
    
    This file is part of MAME32, and may only be used, modified and
    distributed under the terms of the MAME license, in "readme.txt".
    By continuing to use, modify or distribute this file you indicate
    that you have read the license and understand and accept it fully.

 ***************************************************************************/

/***************************************************************************

  NullSound.c

 ***************************************************************************/

#include "Playgame.h"
#include "NullSound.h"

/***************************************************************************
    function prototypes
 ***************************************************************************/

static int      NullSound_init(void);
static void     NullSound_exit(void);

static int      NullSound_start_audio_stream(int stereo);
static int      NullSound_update_audio_stream(INT16* buffer);
static void     NullSound_stop_audio_stream(void);

static void     NullSound_set_mastervolume(int volume);
static int      NullSound_get_mastervolume(void);
static void     NullSound_sound_enable(int enable);
static void     NullSound_update_audio(void);

void     NullSound_opl_control(int chip,int reg);
void     NullSound_opl_write(int chip,int data);

/***************************************************************************
    External variables
 ***************************************************************************/

struct OSDSound NullSound =
{
    { NullSound_init },                     /* init                    */
    { NullSound_exit },					    /* exit                    */
	{ NullSound_start_audio_stream },	    /* start the audio stream  */
    { NullSound_update_audio_stream },	    /* update the audio stream */
    { NullSound_stop_audio_stream },        /* stop the audio stream   */
	{ NullSound_set_mastervolume },         /* set_mastervolume        */
    { NullSound_get_mastervolume },         /* get_mastervolume        */
    { NullSound_sound_enable },             /* sound_enable			   */
    { NullSound_update_audio },	            /* update_audio            */
	{ NullSound_opl_control },	            /* opl_control             */
	{ NullSound_opl_write }					/* opl_write			   */
};


/***************************************************************************
    Internal structures
 ***************************************************************************/

/***************************************************************************
    Internal variables
 ***************************************************************************/

static unsigned int m_nVolume;

/***************************************************************************
    External OSD functions  
 ***************************************************************************/

static int NullSound_init(void)
{
    /* update the Machine structure to show that sound is disabled */
	Machine->sample_rate = 0; //11025;
    m_nVolume = 0;
    return 0;
}

static void NullSound_exit(void)
{
}


static int NullSound_start_audio_stream(int stereo)
{
	return 0;
}

static int      NullSound_update_audio_stream(INT16* buffer)
{
	return 0;
}
static void     NullSound_stop_audio_stream(void)
{
}
static void NullSound_set_mastervolume(int volume)
{
    m_nVolume = volume;
}

static int NullSound_get_mastervolume()
{
    return m_nVolume;
}
static void     NullSound_sound_enable(int enable)
{
}
static void     NullSound_update_audio(void)
{
}
void NullSound_opl_control(int chip,int reg)
{
}

void NullSound_opl_write(int chip,int data)
{
}

/***************************************************************************
    Internal functions
 ***************************************************************************/

