/***************************************************************************

    M.A.M.E.CE3  -  Multiple Arcade Machine Emulator for Pocket PC
    Win32 Portions Copyright (C) 1997-98 Michael Soderstrom and Chris Kirmse
    
    This file is part of MAMECE3, and may only be used, modified and
    distributed under the terms of the MAME license, in "MAME.txt".
    By continuing to use, modify or distribute this file you indicate
    that you have read the license and understand and accept it fully.

 ***************************************************************************/

 /***************************************************************************

  options.c

  Stores global options and per-game options;

***************************************************************************/



#include "options.h"


//#include "MameCE.h"


/***************************************************************************
    Internal function prototypes
 ***************************************************************************/

/***************************************************************************
    Internal structures
 ***************************************************************************/

/***************************************************************************
    Internal variables
 ***************************************************************************/


/***************************************************************************
    External variables
 ***************************************************************************/
/* Added these for the Getmodule Function */

WORD modpath[MAX_PATH];
static char szRootPath[MAX_PATH];
char *p;
char name[MAX_PATH];


/***************************************************************************
    External functions  
 ***************************************************************************/

void OptionsInit(int total_games)
{
    int i;

    num_games = total_games;

	/* Get Module Path */
	GetModuleFileName(NULL, modpath, MAX_PATH);
	WideCharToMultiByte(CP_ACP, 0, 
		modpath, wcslen(modpath) + 1, 
		szRootPath, MAX_PATH - 1, 
		NULL, NULL);
	p = szRootPath + strlen(szRootPath);
	while (p != szRootPath && *p != '\\')
		*p-- = 0;

    //sprintf(name, "%sroms", szRootPath);
	sprintf(name, "%sroms;\\Storage Card%sroms", szRootPath, szRootPath);
	settings.romdirs     = strdup(name);
    //sprintf(name, "%ssamples", szRootPath);
	sprintf(name, "%ssamples;\\Storage Card%ssamples", szRootPath, szRootPath);
	settings.sampledirs  = strdup(name);
    sprintf(name, "%scfg", szRootPath);
	settings.cfgdir      = strdup(name);
    sprintf(name, "%shi", szRootPath);
	settings.hidir       = strdup(name);
    sprintf(name, "%sinp", szRootPath);


    global.use_default = FALSE;

    global.is_window        = FALSE;
    global.display_best_fit = TRUE;
    global.display_monitor  = 0;    /* Primary Display */
    global.width            = 640;
    global.height           = 480;
    global.skip_lines       = 0;
    global.skip_columns     = 0;
    global.double_vector    = FALSE;
    global.window_ddraw     = TRUE;
    global.auto_frame_skip  = options.disable_throttle; //TRUE; //Techmaster
    global.frame_skip       = 0;
    global.use_dirty        = FALSE;
    global.hscan_lines      = TRUE;
    global.vscan_lines      = FALSE;
    global.use_blit         = FALSE;
    global.disable_mmx      = TRUE;
    global.scale            = 2;
    global.rotate           = ROTATE_NONE;
    global.flipx            = FALSE;
    global.flipy            = FALSE;
    global.gamma            = 1.0;
    global.brightness       = 100;
    global.depth            = 8;
    global.antialias        = TRUE;
    global.translucency     = TRUE;
    global.beam             = 1.0;
    global.flicker          = 0;

    global.use_joystick = FALSE;
    global.use_ai_mouse = TRUE;
    global.di_keyboard  = TRUE;
    global.di_joystick  = TRUE;

    for (i=0;i<4;i++)
    {
       global.physical_joysticks[i] = i;
       global.x_axes[i] = 0;
       global.y_axes[i] = 1;
    }

    global.sound        = SOUND_WAVE;
    global.sample_rate  = 11025;
    global.sample_bits  = 8;
    global.volume       = 0;
    global.stereo       = FALSE;

    global.fm_ym3812    = FALSE;

    global.cheat        = FALSE;
    global.auto_pause   = TRUE;
    global.error_log    = FALSE;
    global.profile      = FALSE;
    global.showfps      = FALSE;
    global.use_artwork  = TRUE;
    global.use_samples  = TRUE;

    global.play_count   = 0;
    global.has_roms     = UNKNOWN;
    global.has_samples  = UNKNOWN;
    global.is_favorite  = FALSE;

    /* This allocation should be checked */
    game = (options_type *)malloc(num_games * sizeof(options_type));

    for (i = 0; i < num_games; i++)
    {
        game[i] = global;
        game[i].use_default = TRUE;
    }

}

void OptionsExit()
{
    free(game);
    free(settings.romdirs);
    free(settings.sampledirs);
    free(settings.cfgdir);
    free(settings.hidir);
}


options_type * GetDefaultOptions()
{
    return &global;
}

options_type * GetGameOptions(int num_game)
{
    int play_count;
    int has_roms;
    int has_samples;

    assert(0 <= num_game && num_game < num_games);

    play_count  = game[num_game].play_count;
    has_roms    = game[num_game].has_roms;
    has_samples = game[num_game].has_samples;

    if (game[num_game].use_default)
    {
        game[num_game]              = global;
        game[num_game].use_default  = TRUE;
        game[num_game].play_count   = play_count;
        game[num_game].has_roms     = has_roms;
        game[num_game].has_samples  = has_samples;
    }
    return &game[num_game];
}

void SetVersionCheck(BOOL version_check)
{
    settings.version_check = version_check;
}

BOOL GetVersionCheck(void)
{
    return settings.version_check;
}

const char* GetRomDirs(void)
{
    return settings.romdirs;
}

void SetRomDirs(const char* paths)
{
    if (settings.romdirs != NULL)
    {
        free(settings.romdirs);
        settings.romdirs = NULL;
    }

    if (paths != NULL)
        settings.romdirs = strdup(paths);
}

const char* GetSampleDirs(void)
{
    return settings.sampledirs;
}

void SetSampleDirs(const char* paths)
{
    if (settings.sampledirs != NULL)
    {
        free(settings.sampledirs);
        settings.sampledirs = NULL;
    }

    if (paths != NULL)
        settings.sampledirs = strdup(paths);
}

const char* GetCfgDir(void)
{
    return settings.cfgdir;
}

void SetCfgDir(const char* path)
{
    if (settings.cfgdir != NULL)
    {
        free(settings.cfgdir);
        settings.cfgdir = NULL;
    }

    if (path != NULL)
        settings.cfgdir = strdup(path);
}

const char* GetHiDir(void)
{
    return settings.hidir;
}

void SetHiDir(const char* path)
{
    if (settings.hidir != NULL)
    {
        free(settings.hidir);
        settings.hidir = NULL;
    }

    if (path != NULL)
        settings.hidir = strdup(path);
}

int  GetHasRoms(int num_game)
{
    assert(0 <= num_game && num_game < num_games);

    return game[num_game].has_roms;
}

void SetHasRoms(int num_game, int has_roms)
{
    assert(0 <= num_game && num_game < num_games);

    game[num_game].has_roms = has_roms;
}

int  GetHasSamples(int num_game)
{
    assert(0 <= num_game && num_game < num_games);

    return game[num_game].has_samples;
}

void SetHasSamples(int num_game, int has_samples)
{
    assert(0 <= num_game && num_game < num_games);

    game[num_game].has_samples = has_samples;
}

/***************************************************************************
    Internal functions
 ***************************************************************************/


/* End of options.c */
