/***************************************************************************

    M.A.M.E.CE3  -  Multiple Arcade Machine Emulator for Pocket PC
    Win32 Portions Copyright (C) 1997-98 Michael Soderstrom and Chris Kirmse
    
    This file is part of MAMECE3, and may only be used, modified and
    distributed under the terms of the MAME license, in "MAME.txt".
    By continuing to use, modify or distribute this file you indicate
    that you have read the license and understand and accept it fully.

 ***************************************************************************/

/***************************************************************************

  osdepend.c

  OS dependent stuff (display handling, keyboard scan...)
  Functions in this file are the link to the MAME engine. 
  These functions map back to the Display.c Sound.c etc

 ***************************************************************************/

#include "Playgame.h"

#include "File.h"

#include "NullSound.h"
#include "CESound.h"
#include "Keyboard.h"
#include "GDIDisplay.h"
#include "Trak.h"
#include "uclock.h"

/***************************************************************************
    External variables
 ***************************************************************************/

int     autoframeskip, frameskip;  // Hack, Hack, Hack - FIXME! MSH 01/26/99

/***************************************************************************
    Internal variables
 ***************************************************************************/

/***************************************************************************
    External OSD function definitions  
 ***************************************************************************/

//
// Initialize the OSD components such as the display keyboard etc
//
int osd_init()
{
    BOOL    bNoSound        = FALSE;

    BOOL    bDisplayInitialized  = FALSE;
    BOOL    bSoundInitialized    = FALSE;
    BOOL    bKeyboardInitialized = FALSE;
    BOOL    bTrakInitialized     = FALSE;
    BOOL    bFMSynthInitialized  = FALSE;


	// Get the pointer to the options that we set for the game.
	options_type *options = GetPlayingGameOptions();

	if (options->sound == SOUND_NONE)
		bNoSound = TRUE;

	//
	// Set the MameCE3App initial values (found in PlayGame.c)
	// Set MameCEApp pointers to their proper structure variables 
	//	(defined in the display.h, sound.h, and keyboard.h files) or NULL if not defined
    //
	MAMECE3App_init();

	MAMECE3App.m_pDisplay = &GDIDisplay;

   if (bNoSound == TRUE)
	   MAMECE3App.m_pSound = &NullSound;
   else
	   MAMECE3App.m_pSound = &CESound;

	MAMECE3App.m_pKeyboard = &Keyboard;
	MAMECE3App.m_pJoystick = NULL;
	MAMECE3App.m_pTrak = NULL;

//	if (options->fm_ym3812)
//		MAMECE3App.m_pFMSynth = &FMSynth;
//    else
        MAMECE3App.m_pFMSynth = NULL;

	
	// Attempt to create the Game Window
	MAMECE3App.m_hWnd = CreateMAMEWindow();
	
	if (IsWindow(MAMECE3App.m_hWnd) == FALSE)
        goto error;

    // Game Windows Created successfully - Initialize everything else.
	uclock_init();
	if (MAMECE3App.m_pDisplay != NULL)
    {        
        if (MAMECE3App.m_pDisplay->init(options) != 0)
            goto error;
		else
            bDisplayInitialized = TRUE;
    }

    if (MAMECE3App.m_pSound != NULL)
    {
		if (MAMECE3App.m_pSound->init() != 0)
            goto error;
		else
            bSoundInitialized = TRUE;        
    }

	if (MAMECE3App.m_pKeyboard != NULL)
    {
        if (MAMECE3App.m_pKeyboard->init() != 0)
            goto error;
        else
            bKeyboardInitialized = TRUE;        
    }

    if (MAMECE3App.m_pTrak != NULL)
    {
        if (MAMECE3App.m_pTrak->init() != 0)
            goto error;
        else
            bTrakInitialized = TRUE;
    }
//    if (MAMECE3App.m_pFMSynth != NULL)
//    {
//        if (MAMECE3App.m_pFMSynth->init(options) != 0)
//            goto error;
//        else
//            bFMSynthInitialized = TRUE;
//    }

    MAMECE3App.m_bIsInitialized = TRUE;

	MAMECE3App.m_pSound->set_mastervolume(- options->volume);

    return 0;

error:

//	if (bFMSynthInitialized  == TRUE) MAMECE3App.m_pFMSynth->exit();
	if (bKeyboardInitialized == TRUE) MAMECE3App.m_pKeyboard->exit();
	if (bSoundInitialized    == TRUE) MAMECE3App.m_pSound->exit();
	if (bDisplayInitialized  == TRUE) MAMECE3App.m_pDisplay->exit();
  
	if (IsWindow(MAMECE3App.m_hWnd))
		DestroyWindow(MAMECE3App.m_hWnd);
	
    return 1;
}

void osd_exit(void)
{
	MAMECE3App.m_bIsInitialized = FALSE;
	MAMECE3App.m_bDone = FALSE;

//	if (MAMECE3App.m_pFMSynth  != NULL) MAMECE3App.m_pFMSynth->exit();
	if (MAMECE3App.m_pKeyboard != NULL) MAMECE3App.m_pKeyboard->exit();
	if (MAMECE3App.m_pSound    != NULL) MAMECE3App.m_pSound->exit();
	if (MAMECE3App.m_pDisplay  != NULL) MAMECE3App.m_pDisplay->exit();

	if (IsWindow(MAMECE3App.m_hWnd))
		DestroyWindow(MAMECE3App.m_hWnd);

}

/***************************************************************************
    Display
 ***************************************************************************/

struct osd_bitmap* osd_new_bitmap(int width, int height, int depth)
{
    return GD_new_bitmap(width, height, depth);
}

void osd_free_bitmap(struct osd_bitmap* pBitmap)
{
    GD_free_bitmap(pBitmap);
}

struct osd_bitmap* osd_create_display(int width, int height,int depth, int attributes)
{
    return GD_create_display(width, height, attributes);
}

int osd_set_display(int width,int height,int attributes)
{
    return GD_set_display(width, height, attributes);
}

void osd_close_display(void)
{
    GD_close_display();
}

int osd_allocate_colors(unsigned int totalcolors, const unsigned char *palette, unsigned short *pens, int modifiable) 
{
    GD_allocate_colors(totalcolors, palette, pens, 0);
	return 0;
}

void osd_modify_pen(int pen, unsigned char red, unsigned char green, unsigned char blue)
{
    GD_modify_pen(pen, red, green, blue);
}

void osd_get_pen(int pen, unsigned char* red, unsigned char* green, unsigned char* blue)
{
	GD_get_pen(pen, red, green, blue);
}

void osd_update_video_and_audio(void)
{
	GD_update_display();
	MAMECE3App.m_pSound->update_audio();
}

void osd_clearbitmap(struct osd_bitmap *bitmap)
{
    GD_clearbitmap(bitmap);
}

void osd_mark_dirty(int x1, int y1, int x2, int y2, int ui)
{
	GD_mark_dirty(x1, y1, x2, y2, ui);
}

int osd_skip_this_frame()
{
    return GD_skip_this_frame();
}

void osd_led_w(int led, int on)
{
    ;//GD_led_w;
}

void osd_set_gamma(float _gamma)
{
	GD_set_gamma(_gamma);
}

float osd_get_gamma(void)
{
    return GD_get_gamma();
}

void osd_set_brightness(int brightness)
{
    GD_set_brightness(brightness);
}

int osd_get_brightness(void)
{
    return GD_get_brightness();
}

void osd_save_snapshot(void)
{
	;//GD_save_snapshot();
}

/***************************************************************************
    Sound
 ***************************************************************************/


int osd_start_audio_stream(int stereo)
{
	return MAMECE3App.m_pSound->start_audio_stream(stereo);
}

void osd_stop_audio_stream(void)
{
	MAMECE3App.m_pSound->stop_audio_stream();
}

int osd_update_audio_stream(INT16* buffer)
{
	return MAMECE3App.m_pSound->osd_update_audio_stream(buffer);
}

void osd_set_mastervolume(int attenuation)
{
	MAMECE3App.m_pSound->set_mastervolume(attenuation);
}

int osd_get_mastervolume()
{
    return MAMECE3App.m_pSound->get_mastervolume();
}

void osd_sound_enable(int enable)
{
	MAMECE3App.m_pSound->sound_enable(enable);
}

void osd_opl_control(int chip,int reg)
{
	MAMECE3App.m_pSound->opl_control(chip, reg);
}

void osd_opl_write(int chip,int data)
{
	MAMECE3App.m_pSound->opl_write(chip,data);
}
/***************************************************************************
    Keyboard
 ***************************************************************************/

/*
  return a list of all available keys (see input.h)
*/
const struct KeyboardInfo *osd_get_key_list(void)
{
   return MAMECE3App.m_pKeyboard->get_key_list();
}

/*
  inptport.c defines some general purpose defaults for key bindings. They may be
  further adjusted by the OS dependant code to better match the available keyboard,
  e.g. one could map pause to the Pause key instead of P, or snapshot to PrtScr
  instead of F12. Of course the user can further change the settings to anything
  he/she likes.
  This function is called on startup, before reading the configuration from disk.
  Scan the list, and change the keys you want.
*/
void osd_customize_inputport_defaults(struct ipd *defaults)
{
   MAMECE3App.m_pKeyboard->customize_inputport_defaults(defaults);
}

/*
  tell whether the specified key is pressed or not. keycode is the OS dependant
  code specified in the list returned by osd_customize_inputport_defaults().
*/
int osd_is_key_pressed(int keycode)
{
   return MAMECE3App.m_pKeyboard->is_key_pressed(keycode);
}

/*
  wait for the user to press a key. This function is not required to do anything,
  it is only here so we can avoid bogging down multitasking systems while using
  the debugger. If you don't want to or can't support this function you can just
  return immediately.
*/
int osd_wait_keypress(void)
{
   return MAMECE3App.m_pKeyboard->wait_keypress();
}

void osd_pause(int paused)
{
/*	static float orig_brt;

    if (paused && MAMECEApp.m_bIsPaused == FALSE)
    {
        MAMECEApp.m_bIsPaused = TRUE;

        orig_brt = osd_get_brightness();
		osd_set_brightness(orig_brt * 0.65);
    }
    else
    {
      MAMECEApp.m_bIsPaused = FALSE;
		osd_set_brightness(orig_brt);
    }

    MAMECEApp.m_pDisplay->update_display();
*/}

/***************************************************************************
    Joystick
 ***************************************************************************/

//const struct JoystickInfo *osd_get_joy_list(void)
//{
//    return MAMECEApp.m_pJoystick->get_joy_list();
//}
/* Replace the above routine with 3 in Input.c -  Techmaster */


void osd_poll_joysticks(void)
{
	//
}

int osd_is_joy_pressed(int joycode)
{
	/* Dummy entry for Joysticks since they aren't used in CE */
	return 0;
}

/* Do we need to calibrate the joystick at all? */
int osd_joystick_needs_calibration(void)
{
    return 0;
}

/* Preprocessing for joystick calibration. Returns 0 on success */
void osd_joystick_start_calibration(void)
{
	//
}

/* Prepare the next calibration step. Return a description of this step. */
/* (e.g. "move to upper left") */
char *osd_joystick_calibrate_next(void)
{
	return " ";
}

/* Get the actual joystick calibration data for the current position */
void osd_joystick_calibrate(void)
{
	//
}

/* Postprocessing (e.g. saving joystick data to config) */
void osd_joystick_end_calibration(void)
{
	//
}

void osd_analogjoy_read(int player, int *analog_x, int *analog_y)
{
	//
}

/***************************************************************************
    Trakball
 ***************************************************************************/

void osd_trak_read(int player, int *deltax, int *deltay)
{
	return;
}

/***************************************************************************
    Files
 ***************************************************************************/

int osd_faccess(const char *filename, int filetype)
{
    return File_faccess(filename, filetype);
}

void *osd_fopen(const char *gamename,const char *filename,int filetype,int write)
{
   return File_fopen(gamename,filename,filetype,write);
}

int osd_fread(void *file,void *buffer,int length)
{
    return File_fread(file,buffer,length);
}

int osd_fread_swap(void *file,void *buffer,int length)
{
	int i;
	unsigned char *buf;
	unsigned char temp;
	int res;


	res = osd_fread(file,buffer,length);

	buf = buffer;
	for (i = 0;i < length;i+=2)
	{
		temp = buf[i];
		buf[i] = buf[i+1];
		buf[i+1] = temp;
	}

	return res;

  }

int osd_fwrite(void *file,const void *buffer,int length)
{
	return File_fwrite(file,buffer,length);
}

int osd_fwrite_swap(void *file,const void *buffer,int length)
{
	int i;
	unsigned char *buf;
	unsigned char temp;
	int res;


	buf = (unsigned char *)buffer;
	for (i = 0;i < length;i+=2)
	{
		temp = buf[i];
		buf[i] = buf[i+1];
		buf[i+1] = temp;
	}

	res = osd_fwrite(file,buffer,length);

	for (i = 0;i < length;i+=2)
	{
		temp = buf[i];
		buf[i] = buf[i+1];
		buf[i+1] = temp;
	}

	return res;

}

int osd_fread_scatter(void *file,void *buffer,int length,int increment)
{
	return File_fread_scatter(file, buffer, length, increment);
}

int osd_fseek(void *file,int offset,int whence)
{
	return File_fseek(file,offset,whence);
}

void osd_fclose(void *file)
{
	File_fclose(file);
}

int osd_fchecksum(const char *gamename, const char *filename, unsigned int *length, unsigned int *sum)
{
	return File_fchecksum(gamename, filename, length, sum);
}

int osd_ftell(void *file)
{
	return File_ftell(file);
}

int osd_fsize(void *file)
{
	return File_fsize(file);
}

unsigned int osd_fcrc(void *file)
{
	return File_fcrc(file);
}

int osd_display_loading_rom_message(const char *name,int current,int total)
{
   int retval;

   retval = 0;

   return retval;
}


/***************************************************************************
    Config
 ***************************************************************************/


/***************************************************************************
    Profile
 ***************************************************************************/

void osd_profiler(int type)
{
//	Profiler_profile(type);
}
