/***************************************************************************

    M.A.M.E.CE3  -  Multiple Arcade Machine Emulator for Pocket PC
    Win32 Portions Copyright (C) 1997-98 Michael Soderstrom and Chris Kirmse
    
    This file is part of MAMECE3, and may only be used, modified and
    distributed under the terms of the MAME license, in "MAME.txt".
    By continuing to use, modify or distribute this file you indicate
    that you have read the license and understand and accept it fully.

 ***************************************************************************/

/***************************************************************************

  Playgame.c
  
    Preparation and start of selected game.
    
***************************************************************************/

#include "Playgame.h"

#include "NullSound.h"
#include "CESound.h"
#include "Keyboard.h"
#include "GDIDisplay.h"
#include "Trak.h"

/***************************************************************************
	Function prototypes
***************************************************************************/


/***************************************************************************
	External structures
***************************************************************************/

struct tMAMECEApp   MAMECE3App = 
{
    { NULL },                   // m_hInstance       //
    { NULL },                   // m_hwndUI          //
    { NULL },                   // m_hWnd            //
    { "MAMECE3" },               // m_pName          //
	{ 0	},						// m_nSpeed			 //
    { FALSE },                  // m_bIsInitialized  //
    { FALSE },                  // m_bIsActive       //
    { FALSE },                  // m_bIsPaused       //
    { FALSE },                  // m_bDone           //
    { NULL },                   // m_pDisplay        //
    { NULL },                   // m_pSound          //
    { NULL },                   // m_pKeyboard       //
    { NULL },                   // m_pJoystick       //
    { NULL },                   // m_pTrak           //
    { NULL }					// m_pFMSynth        //
};


/***************************************************************************
	Internal structures
***************************************************************************/


/***************************************************************************
	External variables
 ***************************************************************************/


/***************************************************************************
	Internal variables
***************************************************************************/

options_type tGlobal; /* Global 'default' options */

/***************************************************************************
	External functions
***************************************************************************/

void MamePlayGame(int index, struct ui_options* UI)
{
	tGlobal.hscan_lines		= FALSE;
	tGlobal.scale			= 2;
	tGlobal.gamma			= 1.0;
	tGlobal.brightness		= 100;
	tGlobal.depth			= 8;	// Color Depth 8bit color - 16bit Color etc.
	tGlobal.screendepth		= 8;	// Screen resolution
	
    tGlobal.rotate			= 0;
	tGlobal.frame_skip		= 0;
	

	// Set the UI Options
	tGlobal.auto_frame_skip	= !UI->disable_throttle;
	tGlobal.use_dirty		= UI->enable_dirtyline;
	tGlobal.showfps			= UI->show_framerate;
	tGlobal.profile			= UI->show_profiler;
	
	tGlobal.sound			= UI->enable_sound ? SOUND_WAVE : SOUND_NONE;
	tGlobal.DevID			= UI->DevID;		
 	
	/*
        Need sample rate initialised _before_ rom loading
        for optional rom regions.
    */
    if (tGlobal.sound == SOUND_NONE)
    {
		// update the Machine structure to show that sound is disabled //
		Machine->sample_rate = 0;
		options.samplerate	 = 0;
    }
    else
    {
        Machine->sample_rate = 11025; //Set to minimum for better emulation speed?
        options.samplerate   = 11025; //Set to minimum for better emulation speed
    }

	options.errorlog = NULL;
	options.cheat       = 0; 
    options.gui_host    = 1;
    options.use_samples         = FALSE;
	options.use_emulated_ym3812 = FALSE;
//    options.no_fm               = TRUE;
    
	options.norotate			= FALSE;
	options.flipx = 0;
	options.flipy = 0;
	options.ror = 0;
	options.rol = 0;
	
	if (UI->rotate_right) 
	{
		options.norotate = TRUE;
		options.flipx = 1;
		options.flipy = 1;
	}
	else
	if (UI->rotate_left) options.norotate = TRUE;

    options.beam   = (int)(1 * 0x00010000);
    if (options.beam < 0x00010000)    // beam MUST be at least 1 pixel //
		options.beam = 0x00010000;
    if (options.beam > 0x00100000)    // set max to 16 pixels //
		options.beam = 0x00100000;

	if (UI->enable_flicker) options.flicker = (int)(100 * 2.55);
	else 
		options.flicker = 0;

    if (options.flicker < 0)
        options.flicker = 0;
	if (options.flicker > 255)
        options.flicker = 255;

	if (UI->enable_translucency) options.translucency = TRUE;
	else 
		options.translucency = FALSE; 

	if (UI->enable_antialias) options.antialias = TRUE;
	else
		options.antialias = FALSE; 

	options.use_artwork	= FALSE;
	//options.use_dirty = FALSE;

// Adjust screen size for vector games so they're never larger than device screen
	if (drivers[index]->drv->video_attributes & VIDEO_TYPE_VECTOR)
	{
		int sx, sy;
		struct MachineDriver *machine_drv;
		int ox, oy;
		
		// Get max screen size to fix vector screen sizes with //
		sx = GetSystemMetrics(SM_CXSCREEN);
		sy = GetSystemMetrics(SM_CYSCREEN);
	
			machine_drv = (struct MachineDriver*)ox = drivers[index]->drv;
			ox = machine_drv->screen_width;
			oy = machine_drv->screen_height;

			if (machine_drv->screen_width > sx)
			{
				machine_drv->screen_width = sx;
				machine_drv->screen_height = sy *
					sx / ox;
			}
			
			if (machine_drv->screen_height > sy)
			{
				machine_drv->screen_height = sy;
				machine_drv->screen_width = sx *
					sy / oy;
			}
	}

	//Lets Play that Game !!! :)
	run_game(index);
}


options_type * GetPlayingGameOptions()
{
    return &tGlobal;
}


//
// Initialize the MameCE3App structure before creating the Game Window
//
void MAMECE3App_init()
{
    MAMECE3App.m_hWnd = NULL;

    MAMECE3App.m_bIsInitialized = FALSE;
    MAMECE3App.m_bIsActive      = FALSE;
    MAMECE3App.m_bIsPaused      = FALSE;
    MAMECE3App.m_pDisplay    = NULL;
    MAMECE3App.m_pSound      = NULL;
    MAMECE3App.m_pKeyboard   = NULL;
    MAMECE3App.m_pJoystick   = NULL;
    MAMECE3App.m_pTrak       = NULL;
    MAMECE3App.m_pFMSynth    = NULL;
    MAMECE3App.m_bDone       = FALSE;

    /*
        Machine->scrbitmap is not initialized in the mame source
        until after the call to osd_create_display().
        This causes a problem if osd_create_display() detects an error,
        then shows the error message box, which causes focus to change,
        which causes OnPause() to be called, which uses Machine->scrbitmap.
        Whew. So it needs to be set to NULL so it doesn't crash in OnPause().
    */
    Machine->scrbitmap = NULL;
}


//
//	Create and Register the Game Window and Window Class
//
HWND CreateMAMEWindow(void)
{
    static BOOL		bRegistered = FALSE;
    HINSTANCE       hInstance = GetModuleHandle(NULL);
	HWND			hWnd;
	WNDCLASS		wc;

    if (bRegistered == FALSE)
    {
		wc.style			= CS_HREDRAW | CS_VREDRAW;
		wc.lpfnWndProc		= (WNDPROC) MAMECE3_MessageProc;
		wc.cbClsExtra		= 0;
		wc.cbWndExtra		= 0;
		wc.hInstance		= hInstance;
		wc.hIcon			= LoadIcon(hInstance, MAKEINTRESOURCE(IDI_MAMECE3));
		wc.hCursor			= 0;
		wc.hbrBackground	= (HBRUSH) GetStockObject(BLACK_BRUSH);
		wc.lpszMenuName		= 0;
		wc.lpszClassName	= _T("MAMECE_PLAYWINDOW");

		if (RegisterClass(&wc) == 0)
			return NULL;

        bRegistered = TRUE;
    }

    hWnd = CreateWindow(  _T("MAMECE_PLAYWINDOW"),
                          _T(""),
                          WS_POPUP,
                          0,
						  0,
						  GetSystemMetrics(SM_CXSCREEN),
						  GetSystemMetrics(SM_CYSCREEN) ,
                          MAMECE3App.m_hwndUI,
                          NULL,
                          hInstance,
                          NULL);

	ShowWindow(hWnd, SW_SHOWNORMAL);
	UpdateWindow(hWnd);

	return hWnd;
}


void MAMECE3_Quit()
{
    // Tell MAME to quit. //
    MAMECE3App.m_bDone = TRUE;
}


BOOL MAMECE3_Done()
{
    return MAMECE3App.m_bDone;
}

//BOOL MAMECE_Pause()
//{
//    if (MAMECEApp.m_bIsPaused)
//    {
//        MAMECEApp.m_bIsPaused = FALSE;
//        MAMECEApp.m_bPaused = TRUE;
//        return TRUE;
//    }
//    return FALSE;
//}

//
//	Peek at messages, removing them until we want to Quit or no more messages
//
void MAMECE3_ProcessMessages(void)
{
	MSG Msg;
    
	while (PeekMessage(&Msg, NULL, 0, 0, PM_REMOVE))
    {
        if (Msg.message == WM_QUIT)
        {
            MAMECE3_Quit();
            return;
        }
        
        TranslateMessage(&Msg);
        DispatchMessage(&Msg);
    }
	return;
}


LRESULT CALLBACK MAMECE3_MessageProc(HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam)
{
    LRESULT			Result = 0;

	if (MAMECE3App.m_pDisplay)
	    if (MAMECE3App.m_pDisplay->OnMessage(hWnd, Msg, wParam, lParam, &Result) == TRUE)
		    return Result;

	if (MAMECE3App.m_pTrak)
		if (MAMECE3App.m_pTrak != NULL)
			if (MAMECE3App.m_pTrak->OnMessage(hWnd, Msg, wParam, lParam, &Result) == TRUE)
				return Result;

	if (MAMECE3App.m_pKeyboard)
	    if (MAMECE3App.m_pKeyboard->OnMessage(hWnd, Msg, wParam, lParam, &Result) == TRUE)
		    return Result;

//	if (MAMECE3App.m_pSound)
//	    if (MAMECE3App.m_pSound->OnMessage(hWnd, Msg, wParam, lParam, &Result) == TRUE)
//		    return Result;


    return DefWindowProc(hWnd, Msg, wParam, lParam);
}

/***************************************************************************
	Internal functions  
***************************************************************************/

