#ifndef __PLAYGAME_H__
#define __PLAYGAME_H__

#include "mamece3.h"

#define SOUND_NONE   0
#define SOUND_WAVE   (SOUND_NONE + 1)


struct tMAMECEApp
{
	HINSTANCE				m_hInstance;
    HWND                    m_hwndUI;
    HWND                    m_hWnd;
    const char*             m_Name;

	int						m_nSpeed;	/* Current game speed percentage */

    BOOL                    m_bIsInitialized;
	BOOL					m_bIsActive;
	BOOL					m_bIsPaused;
    BOOL                    m_bDone;

    struct OSDDisplay*      m_pDisplay;
    struct OSDSound*        m_pSound;
    struct OSDKeyboard*     m_pKeyboard;
    struct OSDJoystick*     m_pJoystick;
    struct OSDTrak*         m_pTrak;
    struct OSDFMSynth*      m_pFMSynth;
};


typedef struct
{
	BOOL hscan_lines;
    double gamma;
    int brightness;
	int depth;
	int screendepth;

    int scale;
    int rotate;

	int sound;
    int sample_rate;
    int volume;
    BOOL stereo;
	BOOL no_fm;

	BOOL auto_frame_skip;
 	BOOL showfps;
	int  frame_skip;
//	BOOL auto_pause;
	
	BOOL profile;
	BOOL use_dirty;
	int DevID;

} options_type;


extern struct tMAMECEApp MAMECE3App;


extern void MamePlayGame(int, struct ui_options*);
extern void ErrorMsg(const char* fmt, ...);
extern options_type* GetPlayingGameOptions(void);

extern HWND CreateMAMEWindow(void);
extern void MAMECE3App_init(void);
extern BOOL MAMECE3_Done(void);
extern void MAMECE3_Quit(void);

extern void MAMECE3_ProcessMessages(void);
extern LRESULT CALLBACK MAMECE3_MessageProc(HWND, UINT, WPARAM, LPARAM);



#endif