/***
*winsig.c - C signal support
*
*       Copyright (c) 1991-1997, Microsoft Corporation. All rights reserved
*
*Purpose:
*       Defines signal(), raise() and supporting functions.
*
*******************************************************************************/


//techmaster #include "cruntime.h"
#include <stdlib.h>

/***
*int raise(signum) - Raise a signal
*
*Purpose:
*       This routine raises a signal (i.e., performs the action currently
*       defined for this signal). The action associated with the signal is
*       evoked directly without going through intermediate dispatching or
*       handling.
*
*Entry:
*       int signum - signal type (e.g., SIGINT)
*
*Exit:
*       returns 0 on good return, -1 on bad return.
*
*Exceptions:
*       May not return.  Raise has no control over the action
*       routines defined for the various signals.  Those routines may
*       abort, terminate, etc.  In particular, the default actions for
*       certain signals will terminate the program.
*
*******************************************************************************/


int __cdecl raise (
        int signum
        )
{
	// Don't bother with normal signals..

	_exit(0);

	return -1;
}
