/***************************************************************************

    M.A.M.E.CE3  -  Multiple Arcade Machine Emulator for Pocket PC
    Win32 Portions Copyright (C) 1997-98 Michael Soderstrom and Chris Kirmse
    
    This file is part of MAMECE3, and may only be used, modified and
    distributed under the terms of the MAME license, in "MAME.txt".
    By continuing to use, modify or distribute this file you indicate
    that you have read the license and understand and accept it fully.

 ***************************************************************************/

/***************************************************************************

  CGAPI.cpp: 

 ***************************************************************************/

#include <windows.h>
#include <gx.h>
#include "Cgapi.h"


#define VK_CASSIOPEIA_SLIDER	0x86
#define VK_CASSIOPEIA_ESC		0x87
#define VK_CASSIOPEIA_REC		0xC1
#define VK_CASSIOPEIA_B1		0xC2
#define VK_CASSIOPEIA_B2		0xC3
#define VK_CASSIOPEIA_B3		0xC4

#define VK_CASIO_E115_SLIDER	0x86
#define VK_CASIO_E115_ESC		0xC1
#define VK_CASIO_E115_REC		0xC2
#define VK_CASIO_E115_B1		0xC3
#define VK_CASIO_E115_B2		0xC4
#define VK_CASIO_E115_B3		0x5B

#define VK_IPAQ_ACTION			0x86
#define VK_IPAQ_REC				0x5B
#define VK_IPAQ_B1				0xC1
#define VK_IPAQ_B2				0xC2
#define VK_IPAQ_B3				0xC3
#define VK_IPAQ_B4				0xC4

#define VK_HP_ACTION			0x0D
#define VK_HP_REC				0x1B
#define VK_HP_ROCKER_UP			0x26
#define VK_HP_ROCKER_DOWN		0x28
#define VK_HP_B1				0x25
#define VK_HP_B2				0x27
#define VK_HP_B3				0xC3
#define VK_HP_B4				0xC4

#define VK_HPJ_ACTION			0xD4
#define VK_HPJ_REC				0xC9
#define VK_HPJ_B1				0xC1
#define VK_HPJ_B2				0xD3
#define VK_HPJ_B3				0xD1
#define VK_HPJ_B4				0xD2

#define VK_ATMIGO_ACTION		0x86
#define VK_ATMIGO_REC			0xC1
#define VK_ATMIGO_B1			0xC2
#define VK_ATMIGO_B2			0xC3
#define VK_ATMIGO_B3			0xC5
#define VK_ATMIGO_B4			0xC4
#define VK_ATMIGO_B5			0xC7
#define VK_ATMIGO_B6			0xC6

#define VK_BE300_ROCKET			0x7B
#define VK_BE300_OK				0xC3
#define VK_BE300_ESC			0xC4
#define VK_BE300_OFF			0xC1

/***************************************************************************
    Function prototypes
 ***************************************************************************/

extern "C" {

BOOL		    GAPI_Init(HWND hWnd);
void			GAPI_Close();
void*			GAPI_GetFBAddress();
int				GAPI_GetFBModulo();
int				GAPI_GetFBBpp();
void *			GAPI_BeginDraw();
BOOL			GAPI_EndDraw();
BOOL			GAPI_GetScreenRect(RECT *prc);
SHORT			GAPI_GetAsyncKeyState(int key);
BOOL			GAPI_ClearScreen(unsigned char *line, int width, int height, RGBQUAD *g_palette);
int				GAPI_GetFByPitch();
int				GAPI_GetFBxPitch();
int				GAPI_Suspend();
int				GAPI_Resume();
int				set_device_manufacturer(void);
void			get_keys_array(int *);
void			set_keys_array(int *);
}

void			set_device_keys(int);


/***************************************************************************
    Internal structures
 ***************************************************************************/


/***************************************************************************
    Internal variables
 ***************************************************************************/

/* our dialog/configured options */
GXDisplayProperties g_gxdp;    // GN: GX struct
GXKeyList g_gxkl;              // GX struct

static int iVK1_1Player, iVK1_2Player, iVK1_Coin1, iVK1_Esc, iVK1_UIMenu, iVK1_UIEnter;
static int iVK1_Button1, iVK1_Button2, iVK1_Button3, iVK1_Left, iVK1_Right, iVK1_Up, iVK1_Down;


/***************************************************************************
    Internal functions
 ***************************************************************************/

/***************************************************************************
    External functions  
 ***************************************************************************/

BOOL GAPI_Init(HWND hWnd)
{
	DWORD dwError;
	if (GXOpenDisplay( hWnd, GX_FULLSCREEN) == 0 ) 
	{
		dwError = GetLastError();
	    return FALSE;   // we won't be able to draw.
    }

	if ( GXOpenInput() == 0 )
	{
		return FALSE;
	}

	// Get the Display properties
	g_gxdp = GXGetDisplayProperties();
	// Get information about the Hardware Keys and fills
	// the g_gxkl structure
	g_gxkl = GXGetDefaultKeys(GX_NORMALKEYS);


	return TRUE;
}


void GAPI_Close()
{
	int res;
	res = GXCloseDisplay(); // close GX
	res = GXCloseInput();
}


int	GAPI_Suspend()
{
	return GXSuspend();
}


int	GAPI_Resume()
{
	return GXResume();
}


void* GAPI_GetFBAddress()
{
	void *ptr = GXBeginDraw();
	return ptr;
}


int	GAPI_GetFBModulo()
{
	return 0;
}


int	GAPI_GetFByPitch()
{
	return g_gxdp.cbyPitch;
}


int	GAPI_GetFBxPitch()
{
	return g_gxdp.cbxPitch;
}


int	GAPI_GetFBBpp()
{
	return g_gxdp.cBPP;
}


int	GAPI_GetFBformat()
{
	return g_gxdp.ffFormat;
}


void* GAPI_BeginDraw()
{
	return GXBeginDraw();
}


BOOL GAPI_EndDraw()
{
	return GXEndDraw();
}


BOOL GAPI_GetScreenRect(RECT *prc)
{
	prc->bottom = g_gxdp.cyHeight;
	prc->right = g_gxdp.cxWidth;
	return 0;
}


SHORT GAPI_GetAsyncKeyState(int key)
{
	int newkey = key;

	switch (key)
	{
		case VK_ESCAPE:		newkey = iVK1_Esc; break;
		case VK_F22:		newkey = iVK1_Coin1; break; 
		case VK_F20:		newkey = iVK1_1Player; break;
		case VK_F21:		newkey = iVK1_2Player; break;
		case VK_LCONTROL:	newkey = iVK1_Button1; break;
		case VK_MENU:		newkey = iVK1_Button2; break;
		case VK_SPACE:		newkey = iVK1_Button3; break;
		case VK_TAB:		newkey = iVK1_UIMenu; break;  
		case VK_RETURN:		newkey = iVK1_UIEnter; break;
		case VK_LEFT:		newkey = iVK1_Left; break;
		case VK_RIGHT:		newkey = iVK1_Right; break;
		case VK_UP:			newkey = iVK1_Up; break;
		case VK_DOWN:		newkey = iVK1_Down; break;
	}
	return GetAsyncKeyState(newkey);
}

// New Functions added by Techmaster - These are additions to the original GAPI functions

// set the PocketPC Device's Manufacturer and return the IDsubscript
int set_device_manufacturer(void)
{
	WCHAR wszMachineName[128];
	int iDevID;

	SystemParametersInfo(SPI_GETOEMINFO, sizeof(wszMachineName), &wszMachineName, 0);

	if (wcsncmp(L"Palm-size PC J530",wszMachineName, 17) == 0)
		{iDevID = CASIO_E10X;}
	else if(wcsncmp(L"Pocket PC J580",wszMachineName, 14) == 0)
		{iDevID = CASIO_E115;}
	else if(wcsncmp(L"HP, Jornada 540",wszMachineName, 15) == 0)
			{iDevID = HP_J54X;}
	else if(wcsncmp(L"HP, Jornada 565",wszMachineName, 15) == 0)
			{iDevID = HP_J56X;}
	else if(wcsncmp(L"Compaq iPAQ H3100",wszMachineName, 17) == 0)
			{iDevID = IPAQ_H3135;}
	else if(wcsncmp(L"Compaq iPAQ H3600",wszMachineName, 17) == 0)
			{iDevID = IPAQ_H3600;}
	else if(wcsncmp(L"Compaq iPAQ H3700",wszMachineName, 17) == 0)
			{iDevID = IPAQ_H3700;}
	else if(wcsncmp(L"Compaq iPAQ H3800",wszMachineName, 17) == 0)
			{iDevID = IPAQ_H3800;}
	else if(wcsncmp(L"URTHERE AMIGO",wszMachineName, 13) == 0)
			{iDevID = URT_AMIGO;}
	else
	{ iDevID = X86_EMU;}

	// Initialize the Key Value Structures with the default device keys
	set_device_keys(iDevID);

	return iDevID;
}


// Set the keys for the appropriate Device
void set_device_keys(int DevID)
{

#ifdef x86
	iVK1_Esc		= VK_ESCAPE;
	iVK1_Coin1		= VK_NUMPAD5;
	iVK1_1Player	= VK_NUMPAD1;
	iVK1_2Player	= VK_NUMPAD2;		
	iVK1_Button1	= VK_SPACE;
	iVK1_Button2	= VK_RSHIFT;
	iVK1_Button3	= VK_RCONTROL;
	iVK1_UIMenu		= VK_TAB;
	iVK1_UIEnter	= VK_RETURN;
	iVK1_Left		= VK_LEFT;
	iVK1_Right		= VK_RIGHT;
	iVK1_Up			= VK_UP;
	iVK1_Down		= VK_DOWN;
#endif

#ifdef MIPS
	
	if(DevID == CASIO_E10X) //CASSIOPEIA_E10x
	{
		iVK1_Esc		= VK_CASSIOPEIA_ESC;
		iVK1_Coin1		= VK_CASSIOPEIA_SLIDER;
		iVK1_1Player	= VK_CASSIOPEIA_B1;
		iVK1_2Player	= VK_CASSIOPEIA_B2;
		iVK1_Button1	= VK_CASSIOPEIA_B1;
		iVK1_Button2	= VK_CASSIOPEIA_B2;
		iVK1_Button3	= VK_CASSIOPEIA_B3;
		iVK1_UIMenu		= VK_CASSIOPEIA_REC;
		iVK1_UIEnter	= VK_CASSIOPEIA_B1;
		iVK1_Left		= VK_LEFT;
		iVK1_Right		= VK_RIGHT;
		iVK1_Up			= VK_UP;
		iVK1_Down		= VK_DOWN;
	}
	else if(DevID == CASIO_E115) //CASSIOPEIA_E115
	{
		iVK1_Esc		= VK_CASIO_E115_ESC;
		iVK1_Coin1		= VK_CASIO_E115_SLIDER;
		iVK1_1Player	= VK_CASIO_E115_B1;
		iVK1_2Player	= VK_CASIO_E115_B2;
		iVK1_Button1	= VK_CASIO_E115_B1;
		iVK1_Button2	= VK_CASIO_E115_B2;
		iVK1_Button3	= VK_CASIO_E115_B3;
		iVK1_UIMenu		= VK_CASIO_E115_REC;
		iVK1_UIEnter	= VK_CASIO_E115_B1;
		iVK1_Left		= VK_LEFT;
		iVK1_Right		= VK_RIGHT;
		iVK1_Up			= VK_UP;
		iVK1_Down		= VK_DOWN;
	}
	else //Casio BE300
	{
		iVK1_Esc		= VK_BE300_OK;
		iVK1_Coin1		= VK_BE300_ROCKET;
		iVK1_1Player	= VK_BE300_ROCKET;
		iVK1_2Player	= VK_BE300_ESC;
		iVK1_Button1	= VK_BE300_ESC;
		iVK1_Button2	= VK_BE300_ROCKET;
		iVK1_Left		= VK_LEFT;
		iVK1_Right		= VK_RIGHT;
		iVK1_Up			= VK_UP;
		iVK1_Down		= VK_DOWN;
	}
#endif
	
#ifdef SH3
	iVK1_Esc		= VK_HP_ACTION;
	iVK1_Coin1		= VK_HP_B3;
	iVK1_1Player	= VK_HP_B3;
	iVK1_2Player	= VK_HP_B1;		
	iVK1_Button1	= VK_HP_B4;
	iVK1_Button2	= VK_HP_B3;
	iVK1_Button3	= VK_HP_B1;
	iVK1_UIMenu		= VK_HP_B2;
	iVK1_UIEnter	= VK_HP_B3;
	iVK1_Left		= VK_LEFT;
	iVK1_Right		= VK_RIGHT;
	iVK1_Up			= VK_UP;
	iVK1_Down		= VK_DOWN;
#endif	

#ifdef ARM

	if(DevID == HP_J56X)
	{
		iVK1_Esc		= VK_HPJ_B2;
		iVK1_Coin1		= VK_HPJ_B4;
		iVK1_1Player	= VK_HPJ_B4;
		iVK1_2Player	= VK_HPJ_B3;
		iVK1_Button1	= VK_HPJ_B3;
		iVK1_Button2	= VK_HPJ_B4;
		iVK1_Button3	= VK_HPJ_ACTION;
		iVK1_UIMenu		= VK_HPJ_REC;
		iVK1_UIEnter	= VK_HPJ_ACTION;
		iVK1_Left		= VK_LEFT;
		iVK1_Right		= VK_RIGHT;
		iVK1_Up			= VK_UP;
		iVK1_Down		= VK_DOWN;
	}
	else if(DevID == URT_AMIGO)
	{
		iVK1_Esc		= VK_ATMIGO_REC;
		iVK1_Coin1		= VK_ATMIGO_B1;
		iVK1_1Player	= VK_ATMIGO_B4;
		iVK1_2Player	= VK_ATMIGO_B6;		
		iVK1_Button1	= VK_ATMIGO_B2;
		iVK1_Button2	= VK_ATMIGO_B3;
		iVK1_Button3	= VK_ATMIGO_ACTION;
		iVK1_UIMenu		= VK_ATMIGO_B5;
		iVK1_UIEnter	= VK_ATMIGO_ACTION;
		iVK1_Left		= VK_LEFT;
		iVK1_Right		= VK_RIGHT;
		iVK1_Up			= VK_UP;
		iVK1_Down		= VK_DOWN;
	}
	else if(DevID == IPAQ_H3800)
	{
		iVK1_Esc		= VK_IPAQ_B1;
		iVK1_Coin1		= VK_IPAQ_B4;
		iVK1_1Player	= VK_IPAQ_B4;
		iVK1_2Player	= VK_IPAQ_B3;		
		iVK1_Button1	= VK_IPAQ_B3;
		iVK1_Button2	= VK_IPAQ_B4;
		iVK1_Button3	= VK_IPAQ_ACTION;
		iVK1_UIMenu		= VK_IPAQ_B2;
		iVK1_UIEnter	= VK_IPAQ_REC;
		iVK1_Left		= VK_LEFT;
		iVK1_Right		= VK_RIGHT;
		iVK1_Up			= VK_UP;
		iVK1_Down		= VK_DOWN;
	}
	else //iPaq 3100 or 3600
	{
		iVK1_Esc		= VK_IPAQ_B1;
		iVK1_Coin1		= VK_IPAQ_B3;
		iVK1_1Player	= VK_IPAQ_B3;
		iVK1_2Player	= VK_IPAQ_B1;		
		iVK1_Button1	= VK_IPAQ_ACTION;
		iVK1_Button2	= VK_IPAQ_B4;
		iVK1_Button3	= VK_IPAQ_B3;
		iVK1_UIMenu		= VK_IPAQ_B2;
		iVK1_UIEnter	= VK_IPAQ_REC;
		iVK1_Left		= VK_LEFT;
		iVK1_Right		= VK_RIGHT;
		iVK1_Up			= VK_UP;
		iVK1_Down		= VK_DOWN;
	}
#endif

	return;
}


// Load User supplied codes into Live Game Keys array
void set_keys_array(int * iTempKeyVals)
{
	iVK1_Esc		= iTempKeyVals[0];
	iVK1_Coin1		= iTempKeyVals[1];
	iVK1_1Player	= iTempKeyVals[2];
	iVK1_2Player	= iTempKeyVals[3];		
	iVK1_Button1	= iTempKeyVals[4];
	iVK1_Button2	= iTempKeyVals[5];
	iVK1_Button3	= iTempKeyVals[6];
	iVK1_UIMenu		= iTempKeyVals[7];
	iVK1_UIEnter	= iTempKeyVals[8];
	iVK1_Left		= iTempKeyVals[9];
	iVK1_Right		= iTempKeyVals[10];
	iVK1_Up			= iTempKeyVals[11];
	iVK1_Down		= iTempKeyVals[12];
	
	return;
}

// Load Existing Game Key codes into User Supplied array
void get_keys_array(int * iTempKeyVals)
{
	iTempKeyVals[0] = iVK1_Esc;
	iTempKeyVals[1] = iVK1_Coin1;
	iTempKeyVals[2] = iVK1_1Player;
	iTempKeyVals[3] = iVK1_2Player;
	iTempKeyVals[4] = iVK1_Button1;
	iTempKeyVals[5] = iVK1_Button2;
	iTempKeyVals[6] = iVK1_Button3;
	iTempKeyVals[7] = iVK1_UIMenu;
	iTempKeyVals[8] = iVK1_UIEnter;
	iTempKeyVals[9] = iVK1_Left;
	iTempKeyVals[10] = iVK1_Right;
	iTempKeyVals[11] = iVK1_Up;
	iTempKeyVals[12] = iVK1_Down;
	
	return;
}
