// SEP00 - Gandalf: new functions to support for GAPI

/***************************************************************************

    M.A.M.E.CE3  -  Multiple Arcade Machine Emulator for Pocket PC
    Win32 Portions Copyright (C) 1997-98 Michael Soderstrom and Chris Kirmse
    
    This file is part of MAMECE3, and may only be used, modified and
    distributed under the terms of the MAME license, in "MAME.txt".
    By continuing to use, modify or distribute this file you indicate
    that you have read the license and understand and accept it fully.

 ***************************************************************************/

#ifndef __CGAPI_H__
#define __CGAPI_H__


/***************************************************************************
    Function prototypes
 ***************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

BOOL		    GAPI_Init(HWND hWnd); 
void			GAPI_Close();
void*			GAPI_GetFBAddress();
int				GAPI_GetFBModulo();
int				GAPI_GetFBBpp();
void *			GAPI_BeginDraw();
BOOL			GAPI_EndDraw();
BOOL			GAPI_GetScreenRect(RECT *prc);
SHORT			GAPI_GetAsyncKeyState(int key);
int				GAPI_GetFByPitch();
int				GAPI_GetFBxPitch();
int				GAPI_Suspend();
int				GAPI_Resume();
int				set_device_manufacturer(void);
void			get_keys_array(int *);
void			set_keys_array(int *);

#ifdef __cplusplus
}
#endif

// 11-22-01 Techmaster
// Device ID Definitions
#define X86_EMU		0
#define CASIO_E115	1
#define HP_J54X		2
#define IPAQ_H3135	3
#define IPAQ_H3600	4
#define IPAQ_H3700	5
#define IPAQ_H3800	6
#define HP_J56X		7
#define URT_AMIGO	8
#define CASIO_E10X	9

#endif
