/***************************************************************************

    M.A.M.E.CE3  -  Multiple Arcade Machine Emulator for Pocket PC
    Win32 Portions Copyright (C) 1997-98 Michael Soderstrom and Chris Kirmse
    
    This file is part of MAMECE3, and may only be used, modified and
    distributed under the terms of the MAME license, in "MAME.txt".
    By continuing to use, modify or distribute this file you indicate
    that you have read the license and understand and accept it fully.

 ***************************************************************************/

#ifndef __GDIDISPLAY_H__
#define __GDIDISPLAY_H__


struct osd_bitmap*	  GD_new_bitmap(int width, int height,int depth);
void				  GD_free_bitmap(struct osd_bitmap* bitmap);
struct osd_bitmap*	  GD_create_display(int width, int height, int attributes);
int					  GD_set_display(int width, int height, int attributes);
void				  GD_close_display(void);

int					  GD_allocate_colors(unsigned int totalcolors, const unsigned char *palette, unsigned short *pens, int modifiable);
void				  GD_modify_pen(int pen, unsigned char red, unsigned char green, unsigned char blue);
void				  GD_get_pen(int pen, unsigned char* pRed, unsigned char* pGreen, unsigned char* pBlue);

void				  GD_update_display(void);
void				  GD_clearbitmap(struct osd_bitmap* bitmap);
void				  GD_mark_dirty(int x1, int y1, int x2, int y2, int ui);
int					  GD_skip_this_frame(void);

void				  GD_led_w(int led, int on);
void					  GD_set_gamma(float gamma);
float					  GD_get_gamma(void);
void					  GD_set_brightness(int brightness);
int						  GD_get_brightness(void);

void					  GD_save_snapshot(void);

struct OSDDisplay
{
    int                 (*init)(options_type *options);
    void                (*exit)(void);
	BOOL				(*OnMessage)(HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam, LRESULT* pResult);
};

extern struct OSDDisplay    GDIDisplay;

#endif

