/***************************************************************************

    M.A.M.E. CE  -  Multiple Arcade Machine Emulator for Windows CE
    Win32 Portions Copyright (C) 1997-98 Michael Soderstrom and Chris Kirmse
	Windows CE Portions by Benjamin Cooley    

    This file is part of MAME32, and may only be used, modified and
    distributed under the terms of the MAME license, in "readme.txt".
    By continuing to use, modify or distribute this file you indicate
    that you have read the license and understand and accept it fully.

 ***************************************************************************/

#ifndef __OPTIONS_H__
#define __OPTIONS_H__

#define WIN32_LEAN_AND_MEAN
#include <windows.h>

#define ROTATE_NONE  0
#define ROTATE_RIGHT 1
#define ROTATE_LEFT  2

#define SOUND_NONE   0
#define SOUND_WAVE   (SOUND_NONE + 1)

#define MAX_GAMEDESC 256


/* per-game data we calculate */
enum
{
    UNKNOWN = 2,
};


/* Default input */
enum 
{
    INPUT_LAYOUT_STD,
    INPUT_LAYOUT_HR,
    INPUT_LAYOUT_HRSE,
};


typedef struct
{
    BOOL use_default; /* only for non-default options */
    
    BOOL is_window;
    BOOL double_vector;
    BOOL window_ddraw;
    BOOL auto_frame_skip;
    BOOL use_dirty;
    BOOL hscan_lines;
    BOOL vscan_lines;
    BOOL use_blit;
    BOOL disable_mmx;
    int scale;
    int rotate;
    BOOL flipx;
    BOOL flipy;
    double gamma;
    int brightness;
    int depth;
    BOOL antialias;
    BOOL translucency;
    double beam;
    int flicker;

    BOOL use_joystick;
    BOOL use_ai_mouse;
    BOOL di_keyboard;
    BOOL di_joystick;
	int    default_input;

    int physical_joysticks[4];
    int x_axes[4];
    int y_axes[4];

    int sound;
    int seal_index;
    int sample_rate;
    int sample_bits;
    int volume;
    BOOL stereo;

    BOOL fm_ym3812;

    BOOL cheat;
    BOOL auto_pause;
    BOOL error_log;
    BOOL profile;
	BOOL showfps;
    BOOL use_artwork;       /* Use background artwork if found */
    BOOL use_samples;       /* Use samples if needed? */

    int  play_count;
    int  has_roms;
    int  has_samples;
    BOOL is_favorite;
} options_type;

#ifdef __cplusplus
extern "C" {
#endif
void OptionsInit(int total_games);
void OptionsExit();

options_type * GetDefaultOptions();
options_type * GetGameOptions(int num_game);

