// SetGameKeys.cpp : Defines the entry point for the application.
//

#include "stdafx.h"
#include <aygshell.h>
#include "SetGameKeys.h"
#include "cgapi.h"


#define IDC_RESETDEFAULTS	200
#define IDC_SAVEKEYS		201
#define IDC_CANCEL_CHANGES	202

#define IDC_IDKEYS_EXIT		203
#define IDC_IDKEYS_COINS	204
#define IDC_IDKEYS_1P		205
#define IDC_IDKEYS_2P		206
#define IDC_IDKEYS_FIRE1	207
#define IDC_IDKEYS_FIRE2	208
#define IDC_IDKEYS_FIRE3	209
#define IDC_IDKEYS_UI_MENU	210
#define IDC_IDKEYS_UI_ENTER	211
#define IDC_IDKEYS_LEFT		212
#define IDC_IDKEYS_RIGHT	213
#define IDC_IDKEYS_UP		214
#define IDC_IDKEYS_DOWN		215


#define KEY_TEXT_LITERALS_CNT 13
#define SET_BUTTON_START_COL 309


// Global Variables:
HINSTANCE			  hInst2 = NULL;		// The current instance
static SHACTIVATEINFO s_sai2;

int iKeyCodeVals[KEY_TEXT_LITERALS_CNT] = {0};
int iHoldKeyCodeVals[KEY_TEXT_LITERALS_CNT] = {0};
int iKeyCodeValsID = -1;
BOOL bKeys_Reset = FALSE;

WCHAR *szKeytextliterals[] = {L"Exit Game", L"Coins", L"1Player",L"2Player", L"Fire1",
		L"Fire2",L"Fire3",L"UI Menu",L"UI Enter",L"Left", L"Right", L"Up",L"Down",};

////////////////////////////////////
//  Defined Function Prototypes  //
/////////////////////////////////// 

int		CreateSETKEYWindow(void);
LRESULT CALLBACK SetGameKeys(HWND, UINT, WPARAM, LPARAM);

void	InitSetup(void);
void	get_id_for_newkey(HWND);
BOOL	read_keys_from_registry(void);
BOOL	save_keys_to_registry(void);


/***************************************************************************
    Internal functions
 ***************************************************************************/

//
//	Create and Register the Window and Window Class
//
int CreateSETKEYWindow(void)
{
    static BOOL		bRegistered = FALSE;
    HWND			hWnd;
	WNDCLASS		wc;

    if (bRegistered == FALSE)
    {
		hInst2 = GetModuleHandle(NULL);

		wc.style			= CS_HREDRAW | CS_VREDRAW;
		wc.lpfnWndProc		= (WNDPROC) SetGameKeys;
		wc.cbClsExtra		= 0;
		wc.cbWndExtra		= 0;
		wc.hInstance		= hInst2;
		wc.hIcon			= LoadIcon(hInst2, MAKEINTRESOURCE(IDI_MAMECE3));
		wc.hCursor			= 0;
		wc.hbrBackground	= (HBRUSH) GetStockObject(WHITE_BRUSH);
		wc.lpszMenuName		= 0;
		wc.lpszClassName	= _T("MAMECE_SETKEYSWINDOW");

		if (RegisterClass(&wc) == 0)
			return NULL;
        bRegistered = TRUE;
    }

    hWnd = CreateWindow(  _T("MAMECE_SETKEYSWINDOW"),
                          _T("Reconfigure Game Keys"),
                          WS_VISIBLE,
                          CW_USEDEFAULT,
						  CW_USEDEFAULT,
						  CW_USEDEFAULT,
						  CW_USEDEFAULT,
                          NULL,
                          NULL,
                          hInst2,
                          NULL);
	if (!hWnd)
	{	
		return FALSE;
	}
	return TRUE;
}

// Mesage handler for the Reconfiguring Game Keys box.
LRESULT CALLBACK SetGameKeys(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	HDC hdc;
	int wmId, wmEvent;
	PAINTSTRUCT ps;

	switch (message)
	{
		case WM_COMMAND:
			wmId    = LOWORD(wParam); 
			wmEvent = HIWORD(wParam); 
			// Parse the menu selections:
			switch (wmId)
			{	
				case IDC_CANCEL_CHANGES:
					{
						set_keys_array(iHoldKeyCodeVals);
						SendMessage(hWnd, WM_ACTIVATE, MAKEWPARAM(WA_INACTIVE, 0), (LPARAM)hWnd);
						SendMessage (hWnd, WM_CLOSE, 0, 0);
					}
					break;
				case IDC_RESETDEFAULTS:
					if (wmEvent == BN_CLICKED)
					{
						set_device_manufacturer();
						get_keys_array(iKeyCodeVals);
						
						MessageBox(hWnd, L"Defaults Reset.", L"INFO - MameCE3", MB_OK);

						InvalidateRect(hWnd, NULL, TRUE);
						UpdateWindow(hWnd);
						//dev
						//WCHAR szRegKeystring[125]= {0};
						//readorwrite_game_keys_in_registry(READ_REG, szRegKeystring);
						//UpdateWindow(hWnd);
					}
					break;
				case IDC_SAVEKEYS:
					if (wmEvent == BN_CLICKED)
					{
						set_keys_array(iKeyCodeVals);

						if ( save_keys_to_registry() == FALSE )
							MessageBox(hWnd, L"Key Save to registry failed! Problem is in Function: set_device_keys().", L"ERROR - Cgapi.cpp", MB_OK);
						
						//MessageBox(hWnd, L"Keys SAVED. returning to Main Menu.", L"MameCE3 - INFO", MB_OK);

						SendMessage(hWnd, WM_ACTIVATE, MAKEWPARAM(WA_INACTIVE, 0), (LPARAM)hWnd);
						SendMessage (hWnd, WM_CLOSE, 0, 0);
					}
					break;
				case IDC_IDKEYS_EXIT:
					iKeyCodeValsID = 0;
					goto DOIDKEYPROCESSING;
				case IDC_IDKEYS_COINS:
					iKeyCodeValsID = 1;
					goto DOIDKEYPROCESSING;
				case IDC_IDKEYS_1P:
					iKeyCodeValsID = 2;
					goto DOIDKEYPROCESSING;
				case IDC_IDKEYS_2P:
					iKeyCodeValsID = 3;
					goto DOIDKEYPROCESSING;
				case IDC_IDKEYS_FIRE1:
					iKeyCodeValsID = 4;
					goto DOIDKEYPROCESSING;
				case IDC_IDKEYS_FIRE2:
					iKeyCodeValsID = 5;
					goto DOIDKEYPROCESSING;
				case IDC_IDKEYS_FIRE3:
					iKeyCodeValsID = 6;
					goto DOIDKEYPROCESSING;
				case IDC_IDKEYS_UI_MENU:
					iKeyCodeValsID = 7;
					goto DOIDKEYPROCESSING;
				case IDC_IDKEYS_UI_ENTER:
					iKeyCodeValsID = 8;
					goto DOIDKEYPROCESSING;
				case IDC_IDKEYS_LEFT:
					iKeyCodeValsID = 9;
					goto DOIDKEYPROCESSING;
				case IDC_IDKEYS_RIGHT:
					iKeyCodeValsID = 10;
					goto DOIDKEYPROCESSING;
				case IDC_IDKEYS_UP:
					iKeyCodeValsID = 11;
					goto DOIDKEYPROCESSING;
				case IDC_IDKEYS_DOWN:  
					iKeyCodeValsID = 12;
DOIDKEYPROCESSING:
					if (wmEvent == BN_CLICKED)
					{
						InvalidateRect(hWnd, NULL, TRUE);
						UpdateWindow(hWnd);

						get_id_for_newkey(hWnd);
				
						InvalidateRect(hWnd, NULL, TRUE);
						UpdateWindow(hWnd);
					}
					break;
			}
		case WM_CREATE:
			{
				RECT rBtns;
				int iKeys = IDC_IDKEYS_EXIT, iStep = SET_BUTTON_START_COL;

				GetClientRect(hWnd, &rBtns);

				// Create the 3 Primary Action Keys
				CreateWindowEx(0, _T("BUTTON"), _T("SAVE Changes"),
					WS_VISIBLE | WS_CHILD | WS_TABSTOP, 
					5, rBtns.bottom - 50, 110, 20, 
					hWnd, (HMENU)IDC_SAVEKEYS, hInst2, NULL); 
				CreateWindowEx(0, _T("BUTTON"), _T("CANCEL Changes"),
					WS_VISIBLE | WS_CHILD | WS_TABSTOP, 
					125, rBtns.bottom - 50, 110, 20, 
					hWnd, (HMENU)IDC_CANCEL_CHANGES, hInst2, NULL);
				CreateWindowEx(0, _T("BUTTON"), _T("Reset to Defaults"),
					WS_VISIBLE | WS_CHILD | WS_TABSTOP, 
					60, rBtns.bottom - 80, 120, 20, 
					hWnd, (HMENU)IDC_RESETDEFAULTS, hInst2, NULL);

				// Create all the SET keys
				while (iKeys != (IDC_IDKEYS_EXIT + KEY_TEXT_LITERALS_CNT))
				{
					CreateWindowEx(0, _T("BUTTON"), _T("Set"),
						WS_VISIBLE | WS_CHILD | WS_TABSTOP, 
						5, rBtns.bottom - (iStep -= 16), 30, 14, 
						hWnd, (HMENU)iKeys++, hInst2, NULL);
				}
			}
				break;
		case WM_PAINT:
			RECT rt;
			WCHAR szKeystring[200];
			int loop;

			hdc = BeginPaint(hWnd, &ps);
			GetClientRect(hWnd, &rt);
			
			for (loop = 0; loop < KEY_TEXT_LITERALS_CNT; loop++)
			{
				if (loop == (iKeyCodeValsID) )
					wsprintf(szKeystring, L"                           ....");
				else				
					wsprintf(szKeystring, L"                           0x%X", iKeyCodeVals[loop]);

				DrawText(hdc, szKeystring, _tcslen(szKeystring), &rt, 
					DT_LEFT);
				wsprintf(szKeystring, L"           %s", szKeytextliterals[loop]);
				rt.top += 2 + DrawText(hdc, szKeystring, wcslen(szKeystring), &rt, 
					DT_LEFT);
			}
		
			EndPaint(hWnd, &ps);
			break;
		case WM_DESTROY:
			PostQuitMessage(0);
			break;
		case WM_SETTINGCHANGE:
			SHHandleWMSettingChange(hWnd, wParam, lParam, &s_sai2);
     		break;
		default:
			return DefWindowProc(hWnd, message, wParam, lParam);
   }
   return 0;
}



/***************************************************************************
    Start of Sub Routine Internal functions  
 ***************************************************************************/

 // Initialize Key Value Array and store current key values
void InitSetup(void)
{
	// just to be safe, initialize keys to factory defaults
	set_device_manufacturer();

	// Then check to see if we have keys stored in the registry
	if ( !read_keys_from_registry() )
		get_keys_array(iKeyCodeVals);
	
	// Save the current set of Key Codes in case we decide not to save our changes
	for(int loop = 0; loop < KEY_TEXT_LITERALS_CNT; loop++)
		iHoldKeyCodeVals[loop] = iKeyCodeVals[loop];
	
	return;
}


// Get the New Code for the Key you want to change
void get_id_for_newkey(HWND hWnd)
{
	MSG Msg;

	while (GetMessage(&Msg, NULL, WM_KEYDOWN , WM_KEYDOWN))
    {
		if (LOWORD(Msg.wParam) != 0x5b)
		{
			iKeyCodeVals[iKeyCodeValsID] = 	LOWORD(Msg.wParam);
			iKeyCodeValsID = -1;

			// Flush out any mutliple clicks on the SET button
			while (PeekMessage(&Msg, NULL, 0, 0, PM_REMOVE))
			{
				if (Msg.message == WM_QUIT)
					break;
			}
			return;
		}
		TranslateMessage(&Msg);
        DispatchMessage(&Msg);
    }
}


// Read Key Values from the registry
BOOL read_keys_from_registry(void)
{
	WCHAR szRegKeystring[KEYBUFFER_LEN]; 
	
	// If reading keys from Registry fails, return negative lookup
	if ( access_game_keys_in_registry(READ_REG, szRegKeystring) == FALSE || 
		(wcslen(szRegKeystring) == 0) )
		return FALSE;

	// otherwise there are valid key codes in the registry
	int iStep = 0, iCharStep = 0;
	WCHAR *ps, *pe;
	WCHAR szHoldVal[4]={0};
	
	ps = szRegKeystring;
	pe = (szRegKeystring + wcslen(szRegKeystring)) + 1;
	
	// Sort each Key Code into an array element
	while (ps != pe)
	{
		if (*ps == ',')
		{
			szHoldVal[iCharStep] = NULL;
			iKeyCodeVals[iStep++] = _wtoi(szHoldVal);
			wcscpy(szHoldVal,L"");
			iCharStep = 0;
		}
		else 
			szHoldVal[iCharStep++] = *ps;

		ps++;
	}
	szHoldVal[iCharStep] = NULL;
	iKeyCodeVals[iStep++] = _wtoi(szHoldVal);
	
	return TRUE;
}


// Save Key Values into the registry
BOOL save_keys_to_registry(void)
{
	WCHAR szRegKeystring[KEYBUFFER_LEN] = {0};
	WCHAR szHoldstring[5];

	for ( int loop = 0; loop < (KEY_TEXT_LITERALS_CNT - 1); loop++ )
	{
		wsprintf(szHoldstring, L"%d,",iKeyCodeVals[loop]);
		wcscat(szRegKeystring, szHoldstring);
	}
		wsprintf(szHoldstring, L"%d",iKeyCodeVals[loop]);
		wcscat(szRegKeystring, szHoldstring);

	if ( access_game_keys_in_registry(WRITE_REG, szRegKeystring) == FALSE )
		return FALSE;

	return TRUE;
}



/***************************************************************************
    External functions  
 ***************************************************************************/

// Entry point into Configuration Window
void ReconfigureGameKeys(HWND hWnd)
{
	MSG msg;

	InitSetup();

	if ( CreateSETKEYWindow() == FALSE )
	{
		MessageBox(hWnd, L"Can't create Reconfiguration Window!   Problem is in Function: ReconfigureGameKeys()", L"ERROR - SetGameKeys.cpp", MB_OK);
		return;
	}
	
	// Main message loop:
	while (GetMessage(&msg, NULL, 0, 0)) 
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
}


// Read Game Keys from or Write Game Keys to the registry
BOOL access_game_keys_in_registry(int bReadWrite, WCHAR * pRegKeystring)
{
	HKEY phkMameCE3; LPDWORD result	= NULL;

	// Open the MameCE3 Registry Key
	if (RegCreateKeyEx(HKEY_LOCAL_MACHINE, TEXT("SOFTWARE\\Apps\\Techmaster's MegaCE3"), 0, NULL, 0, 0, NULL, &phkMameCE3, result) != ERROR_SUCCESS )
		return FALSE;

	if (bReadWrite == READ_REG)
	{
		DWORD dwBuffersize = KEYBUFFER_LEN; // Set to 256. If you need more space you should be writing to a file instead
		PBYTE bBuffer = (PBYTE)LocalAlloc(LMEM_FIXED|LMEM_ZEROINIT, dwBuffersize);

		if ( RegQueryValueEx(phkMameCE3, TEXT("MameKeyCodes"), NULL, NULL, bBuffer, &dwBuffersize) != ERROR_SUCCESS )
		{
			RegCloseKey(phkMameCE3);
			return FALSE;
		}
		// Copy the temporary Buffer with the key values into the passed string pointer, for processing upon return
		wcsncpy(pRegKeystring, (WCHAR *)bBuffer, dwBuffersize);
		LocalFree(bBuffer);
		
		// Also if the returned string is -1, return a negative lookup
		if ( (wcslen(pRegKeystring) == 0) || (wcsncmp(L"-1,",pRegKeystring, 3) == 0) )
			return FALSE;
	}
	else if(bReadWrite == WRITE_REG) 
	{
		if ( RegSetValueEx(phkMameCE3, TEXT("MameKeyCodes"), 0, REG_SZ, (BYTE *)pRegKeystring, (lstrlen(pRegKeystring)+1)* sizeof(TCHAR) ) != ERROR_SUCCESS )
		{
			RegCloseKey(phkMameCE3);
			return FALSE;
		}
	}
	else
		return FALSE; //do neither and register a failure, Bogus Value apparently passed to us

	RegCloseKey(phkMameCE3);
	return TRUE;
}
