/***************************************************************************

    M.A.M.E.CE  -  Multiple Arcade Machine Emulator for WinCE
    Win32 Portions Copyright (C) 1997-98 Michael Soderstrom and Chris Kirmse
	WinCE Portions Copyright (C) 1999 Benjamin Cooley
    
    This file is part of MAMECE, and may only be used, modified and
    distributed under the terms of the MAME license, in "readme.txt".
    By continuing to use, modify or distribute this file you indicate
    that you have read the license and understand and accept it fully.

 ***************************************************************************/

/***************************************************************************

  uclock.c

 ***************************************************************************/




#include "uclock.h"

/***************************************************************************
    External variables
 ***************************************************************************/

LONGLONG UCLOCKS_PER_SEC = -1;

/***************************************************************************
    Internal variables
 ***************************************************************************/

/***************************************************************************
    External functions  
 ***************************************************************************/

#ifdef MIPS
void __asm(char*, ...); 
#pragma intrinsic(__asm) // this is actually optional 
#endif

uclock_t uclock(void)
{
    LARGE_INTEGER   tick_count;
#ifdef _x86
	__asm { 
		rdtsc
		mov tick_count.LowPart, eax
		mov tick_count.HighPart, edx
		  }
#else
    QueryPerformanceCounter(&tick_count);
#endif

    return tick_count.QuadPart;
}

int uclock_init()
{
    LARGE_INTEGER   tick_frequency;

    if (UCLOCKS_PER_SEC != -1)
        return 0;

    QueryPerformanceFrequency(&tick_frequency);
    UCLOCKS_PER_SEC = tick_frequency.QuadPart;       

    return 0;
}

int uclock_exit()
{
    return 0;
}
