
struct GameDriver
{
	const char *source_file;	/* set this to __FILE__ */
	const struct GameDriver *clone_of;	/* if this is a clone, point to */
										/* the main version of the game */
	const char *name;
	const char *description;
	const char *year;
	const char *manufacturer;
	const struct MachineDriver *drv;
	const struct InputPortTiny *input_ports;
	void (*driver_init)(void);	/* optional function to be called during initialization */
								/* This is called ONCE, unlike Machine->init_machine */
								/* which is called every time the game is reset. */

	const struct RomModule *rom;


	UINT32 flags;	/* orientation and other flags; see defines below */
};

#define NOT_A_DRIVER			0x4000	/* set by the fake "root" driver_ and by "containers" */


struct GameDriver driver_0 =
{
	__FILE__,
	0,
	"",
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	NOT_A_DRIVER
};

struct GameDriver driver_pacman =
{
	"pacman",
	0,
	"pacman",
	"Pacman",
	"1981",
	"Konami",
	0,
	0,
	0,
	0,//rom_frogger,
	0 //ROT90
};

struct GameDriver driver_1943 =
{
	"1943",
	0,
	"1943",
	"1943 - The Battle of Midway (US)",
	"1987",
	"Capcom",
	0,
	0,
	0,
	0, //rom_1943,
	0 //ROT270
};



#define DRIVER(NAME) &driver_##NAME,


const struct GameDriver *drivers[] =
{
	DRIVER( pacman )	/* (c) 1980 Namco */
	DRIVER( 1943 )	/* (c) 1980 Namco */
	0
};
